package nccloud.web.fip.orgclass.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import nc.itf.fip.classdef.IClassDefService;
import nc.itf.fip.opreatinglog.IFactoryQueryService;
import nc.vo.bd.pub.BDCacheQueryUtil;
import nc.vo.fip.billregister.BillRegisterVO;
import nc.vo.fip.classdef.ClassDefineVO;
import nc.vo.fip.docview.DocViewListVO;
import nc.vo.fip.docview.DocViewVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.org.AccbookVO;
import nc.vo.org.AccountingBookVO;
import nc.vo.org.FactoryVO;
import nc.vo.org.LiabilityBookVO;
import nc.vo.org.OrgVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.pattern.GridConvertor;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billgrid.BillGrid;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.classdef.IWebModuleClassdefService;
import nccloud.web.fip.classdef.action.QryAndSaveInfoVo;
import nccloud.web.fip.docview.action.DocViewGridConvertUtil;

public class OrgclassListQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         QryAndSaveInfoVo infod = (QryAndSaveInfoVo)json.fromJson(e, QryAndSaveInfoVo.class);
         String con = infod.getPagecode();
         String[] cons = con.split(",");
         ClassDefineVO classDefineVO = infod.getClassDefineVO();
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         ClassDefineVO vo = new ClassDefineVO();
         vo.setPk_group(pk_group);
         vo.setPk_org(cons[1]);
         vo.setDes_billtype(cons[2]);
         BillRegisterVO billRegisterVO = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).getBillRegisterInfoWeb(pk_group, cons[2]);
         String desdoctype = null;
         desdoctype = billRegisterVO == null?null:billRegisterVO.getOrg_entity_id();
         vo.setDesdoctype(desdoctype);
         if(info.getOid() != null) {
            vo.setSrc_system(info.getOid());
         } else {
            vo.setSrc_system(classDefineVO.getSrc_system());
         }

         ClassDefineVO[] vos = ((IClassDefService)ServiceLocator.find(IClassDefService.class)).queryByVO(vo);
         if(vos == null) {
            return null;
         } else {
            DocViewListVO[] viewvos = null;
            DocViewVO[] doviewVos = null;
            if(classDefineVO != null) {
               BillRegisterVO convertor1 = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).getBillRegisterInfoWeb(pk_group, classDefineVO.getDes_billtype());
               String grid1 = null;
               grid1 = convertor1 == null?null:convertor1.getClass_entity_id();
               classDefineVO.setDesdoctype(grid1);
               viewvos = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).doQuerDocViewListVO(classDefineVO);
            } else {
               viewvos = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).doQuerDocViewListVO(vos[0]);
            }

            if(viewvos != null && viewvos.length > 0) {
               doviewVos = viewvos[0].getClassviews();
            }

            GridConvertor var33 = new GridConvertor();
            Grid var34 = var33.toGrid("classdefine", vos);
            Grid grid2 = null;
            if(doviewVos != null && doviewVos.length > 0) {
               grid2 = DocViewGridConvertUtil.toGridForDocView(Arrays.asList(viewvos), viewvos[0].getDesdocid(), "classviews");
            }

            HashSet accountingpks = new HashSet();
            HashSet orgpks = new HashSet();
            ClassDefineVO[] accountingBookVOs = vos;
            int accountingBookMap = vos.length;

            for(int currLangIndex = 0; currLangIndex < accountingBookMap; ++currLangIndex) {
               ClassDefineVO orgvos = accountingBookVOs[currLangIndex];
               if(orgvos.getDefaultvalue() != null) {
                  accountingpks.add(orgvos.getDefaultvalue());
               }

               if(orgvos.getPk_org() != null) {
                  orgpks.add(orgvos.getPk_org());
               }
            }

            accountingBookVOs = null;
            HashMap var36 = new HashMap();
            Object var37 = MultiLangContext.getInstance().getCurrentLangSeq().intValue();
            int maporg;
            int bgrid;
            Object translator;
            Object[] var35;
            Object[] var38;
            int var43;
            if("NRESA03".equalsIgnoreCase(vos[0].getDes_billtype())) {
               var35 = BDCacheQueryUtil.queryVOsByIDs(LiabilityBookVO.class, "pk_liabilitybook", (String[])accountingpks.toArray(new String[0]), (String[])null);
               var38 = var35;
               maporg = var35.length;

               for(bgrid = 0; bgrid < maporg; ++bgrid) {
                  translator = var38[bgrid];
                  LiabilityBookVO grids = (LiabilityBookVO)translator;
                  if(grids != null && grids.getPk_liabilitybook() != null && grids.getName() != null) {
                     if(var37 == 1) {
                        var36.put(grids.getPk_liabilitybook(), grids.getAttributeValue("name") == null?"":grids.getAttributeValue("name").toString());
                     } else {
                        var36.put(grids.getPk_liabilitybook(), grids.getAttributeValue((String)var37) == null?grids.getAttributeValue("name").toString():grids.getAttributeValue((String)var37).toString());
                     }
                  }
               }
            } else if("C0".equalsIgnoreCase(vos[0].getDes_billtype())) {
               var35 = BDCacheQueryUtil.queryVOsByIDs(AccountingBookVO.class, "pk_accountingbook", (String[])accountingpks.toArray(new String[0]), (String[])null);
               var38 = var35;
               maporg = var35.length;

               for(bgrid = 0; bgrid < maporg; ++bgrid) {
                  translator = var38[bgrid];
                  AccountingBookVO var44 = (AccountingBookVO)translator;
                  if(var44 != null && var44.getPk_accountingbook() != null && var44.getName() != null) {
                     if(var37 == true) {
                        var36.put(var44.getPk_accountingbook(), var44.getAttributeValue("name") == null?"":var44.getAttributeValue("name").toString());
                     } else {
                        var36.put(var44.getPk_accountingbook(), var44.getAttributeValue((String)var37) == null?var44.getAttributeValue("name").toString():var44.getAttributeValue((String)var37).toString());
                     }
                  }
               }
            } else if(!"CCA02".equalsIgnoreCase(vos[0].getDes_billtype()) && !"ICA03".equalsIgnoreCase(vos[0].getDes_billtype())) {
               ArrayList var39 = new ArrayList(accountingpks);
               String var40 = "11 = 11  and ( enablestate = 2 ) ";
               String var42 = "";

               for(var43 = 0; var43 < var39.size(); ++var43) {
                  if(var43 == 0) {
                     var42 = (String)var39.get(0);
                  } else {
                     var42 = (String)var39.get(var43);
                  }
               }

               if(!"".equals(var42)) {
                  FactoryVO[] var46 = ((IFactoryQueryService)ServiceLocator.find(IFactoryQueryService.class)).queryFactoryByCondition(var42);
                  if(var46 != null) {
                     FactoryVO[] var48 = var46;
                     int cell1 = var46.length;

                     for(int cell2 = 0; cell2 < cell1; ++cell2) {
                        FactoryVO cell3 = var48[cell2];
                        if(cell3 != null && cell3.getPk_factory() != null && cell3.getName() != null) {
                           if(var37 == true) {
                              var36.put(cell3.getPk_factory(), cell3.getAttributeValue("name") == null?"":cell3.getAttributeValue("name").toString());
                           } else {
                              var36.put(cell3.getPk_factory(), cell3.getAttributeValue((String)var37) == null?cell3.getAttributeValue("name").toString():cell3.getAttributeValue((String)var37).toString());
                           }
                        }
                     }
                  }
               }
            } else {
               var35 = BDCacheQueryUtil.queryVOsByIDs(AccbookVO.class, "pk_accbook", (String[])accountingpks.toArray(new String[0]), (String[])null);
               var38 = var35;
               maporg = var35.length;

               for(bgrid = 0; bgrid < maporg; ++bgrid) {
                  translator = var38[bgrid];
                  AccbookVO var45 = (AccbookVO)translator;
                  if(var45 != null && var45.getPk_accbook() != null && var45.getName() != null) {
                     if(var37 == true) {
                        var36.put(var45.getPk_accbook(), var45.getAttributeValue("name") == null?"":var45.getAttributeValue("name").toString());
                     } else {
                        var36.put(var45.getPk_accbook(), var45.getAttributeValue((String)var37) == null?var45.getAttributeValue("name").toString():var45.getAttributeValue((String)var37).toString());
                     }
                  }
               }
            }

            var38 = BDCacheQueryUtil.queryVOsByIDs(OrgVO.class, "pk_org", (String[])orgpks.toArray(new String[0]), (String[])null);
            HashMap var41 = new HashMap();
            Object[] var47 = var38;
            var43 = var38.length;

            for(int var49 = 0; var49 < var43; ++var49) {
               Object var50 = var47[var49];
               if((OrgVO)var50 != null) {
                  if(var37 == true) {
                     var41.put(((OrgVO)var50).getPk_org(), ((OrgVO)var50).getAttributeValue("name") == null?"":((OrgVO)var50).getAttributeValue("name").toString());
                  } else {
                     var41.put(((OrgVO)var50).getPk_org(), ((OrgVO)var50).getAttributeValue((String)var37) == null?((OrgVO)var50).getAttributeValue("name").toString():((OrgVO)var50).getAttributeValue((String)var37).toString());
                  }
               }
            }

            if(var34.getModel() != null && var34.getModel().getRows() != null) {
               for(bgrid = 0; bgrid < var34.getModel().getRows().length; ++bgrid) {
                  Row var51 = var34.getModel().getRows()[bgrid];
                  Cell var55 = new Cell();
                  if(vos != null && vos[bgrid].getClassfactor() != null && vos[bgrid].getClassfactor().length > 0) {
                     if(var37 == true) {
                        var55.setDisplay(vos[bgrid].getClassfactor()[0].getAttributeValue("displayname") == null?"":vos[bgrid].getClassfactor()[0].getAttributeValue("displayname").toString());
                     } else {
                        var55.setDisplay(vos[bgrid].getClassfactor()[0].getAttributeValue((String)var37) == null?vos[bgrid].getClassfactor()[0].getAttributeValue("displayname").toString():vos[bgrid].getClassfactor()[0].getAttributeValue((String)var37).toString());
                     }
                  }

                  var51.getValues().put("pk_classfactor", var55);
                  Cell var53 = new Cell();
                  if(var51.getValues().get("pk_classview") != null && ((Cell)var51.getValues().get("pk_classview")).getValue() != null && !"".equals(((Cell)var51.getValues().get("pk_classview")).getValue())) {
                     var53.setDisplay(NCLangRes4VoTransl.getNCLangRes().getStrByID("10170404", "1101704040003"));
                     var53.setValue(((Cell)var51.getValues().get("pk_classview")).getValue());
                  }

                  var51.getValues().put("pk_classview", var53);
                  Cell var57 = new Cell();
                  if(var51.getValues().get("defaultvalue") != null) {
                     var57.setValue(((Cell)var51.getValues().get("defaultvalue")).getValue());
                     var57.setDisplay((String)var36.get(((Cell)var51.getValues().get("defaultvalue")).getValue()));
                  }

                  var51.getValues().put("defaultvalue", var57);
                  Cell var58 = new Cell();
                  if(var51.getValues().get("pk_org") != null) {
                     var58.setValue(((Cell)var51.getValues().get("pk_org")).getValue());
                     var58.setDisplay((String)var41.get(((Cell)var51.getValues().get("pk_org")).getValue()));
                  }

                  var51.getValues().put("pk_org", var58);
               }
            }

            BillGrid var54 = new BillGrid();
            var54.setHead(var34);
            var54.setBody(grid2);
            var54.setPageid("10170404_1017040401");
            Translator var52 = new Translator();
            var52.translate(var54);
            ArrayList var56 = new ArrayList();
            var56.add(var34);
            var56.add(grid2);
            return var56;
         }
      } catch (Exception var32) {
         ExceptionUtils.wrapException(var32);
         return null;
      }
   }
}
