package nccloud.web.fip.orgclass.action;

import java.util.ArrayList;
import nc.itf.fip.classdef.IClassDefService;
import nc.itf.fip.impacfactor.IImpacFactorService;
import nc.vo.bd.meta.BatchOperateVO;
import nc.vo.fip.billregister.BillRegisterVO;
import nc.vo.fip.classdef.ClassDefineVO;
import nc.vo.fip.classdef.ClassFactorVO;
import nc.vo.fip.impacfactor.ImpacFactorVO;
import nccloud.commons.lang.ArrayUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.pattern.GridConvertor;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.classdef.IWebModuleClassdefService;
import nccloud.web.fip.classdef.action.QryAndSaveInfoVos;

public class OrgclassInsertAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         GridConvertor e = new GridConvertor();
         String str1 = request.read();
         IJson json = JsonFactory.create();
         QryAndSaveInfoVos info = (QryAndSaveInfoVos)json.fromJson(str1, QryAndSaveInfoVos.class);
         ClassDefineVO[] classDefineVOs = info.getClassDefineVO();
         if(ArrayUtils.isNotEmpty(classDefineVOs)) {
            ClassDefineVO[] pk_group = classDefineVOs;
            int des_billtype = classDefineVOs.length;

            for(int ip = 0; ip < des_billtype; ++ip) {
               ClassDefineVO factors = pk_group[ip];
               if("".equals(factors.getPk_classmainprop())) {
                  factors.setPk_classmainprop((String)null);
               }
            }
         }

         String var30 = SessionContext.getInstance().getClientInfo().getPk_group();
         String var31 = info.getPagecode().split(",")[2];
         IImpacFactorService var32 = (IImpacFactorService)ServiceLocator.find(IImpacFactorService.class);
         ImpacFactorVO qvo = new ImpacFactorVO();
         qvo.setPk_group(var30);
         qvo.setPk_systypecode(classDefineVOs[0].getSrc_system());
         ImpacFactorVO[] var33 = var32.queryByVO(qvo);
         ClassDefineVO[] billRegisterVOd = classDefineVOs;
         int desdoctyped = classDefineVOs.length;

         for(int grid = 0; grid < desdoctyped; ++grid) {
            ClassDefineVO addVOLst = billRegisterVOd[grid];
            String[] updateVOLst = addVOLst.getDes_billtype().split(",");
            StringBuilder deleteVOLst = new StringBuilder();
            StringBuilder batchVO = new StringBuilder();
            StringBuilder service = new StringBuilder();
            StringBuilder resultVO = new StringBuilder();
            StringBuilder allVOs = new StringBuilder();
            StringBuilder vo = new StringBuilder();
            if(updateVOLst.length > 0) {
               addVOLst.setDes_billtype(updateVOLst[0]);
            }

            ClassFactorVO[] vos = addVOLst.getClassfactor();
            if(updateVOLst.length > 1 && !updateVOLst[1].equals("-1")) {
               ClassFactorVO pkfactor1;
               if(vos == null) {
                  vos = new ClassFactorVO[1];
                  pkfactor1 = new ClassFactorVO();
                  vos[0] = pkfactor1;
               }

               for(pkfactor1 = 1; pkfactor1 < 10; ++pkfactor1) {
                  if(!updateVOLst[1].equals("undefined")) {
                     vos[0].setAttributeValue(pkfactor1, (Object)null);
                  }
               }

               for(pkfactor1 = 1; pkfactor1 < updateVOLst.length; ++pkfactor1) {
                  if(!updateVOLst[pkfactor1].equals("undefined")) {
                     vos[0].setAttributeValue(pkfactor1, updateVOLst[pkfactor1]);
                     if(var33 != null) {
                        ImpacFactorVO[] o = var33;
                        int var26 = var33.length;

                        for(int var27 = 0; var27 < var26; ++var27) {
                           ImpacFactorVO vo1 = o[var27];
                           if(updateVOLst[pkfactor1].equals(vo1.getPk_factor())) {
                              if(vo1.getDisplayname() != null) {
                                 deleteVOLst.append(vo1.getDisplayname()).append(",");
                              }

                              if(vo1.getDisplayname2() != null) {
                                 batchVO.append(vo1.getDisplayname2()).append(",");
                              }

                              if(vo1.getDisplayname3() != null) {
                                 service.append(vo1.getDisplayname3()).append(",");
                              }

                              if(vo1.getDisplayname4() != null) {
                                 resultVO.append(vo1.getDisplayname4()).append(",");
                              }

                              if(vo1.getDisplayname5() != null) {
                                 allVOs.append(vo1.getDisplayname5()).append(",");
                              }

                              if(vo1.getDisplayname6() != null) {
                                 vo.append(vo1.getDisplayname6()).append(",");
                              }
                           }
                        }
                     }

                     if(!deleteVOLst.isEmpty()) {
                        vos[0].setDisplayname(deleteVOLst.substring(0, deleteVOLst.length() - 1));
                     } else {
                        vos[0].setDisplayname("");
                     }

                     if(!batchVO.isEmpty()) {
                        vos[0].setDisplayname2(batchVO.substring(0, batchVO.length() - 1));
                     } else {
                        vos[0].setDisplayname2("");
                     }

                     if(!service.isEmpty()) {
                        vos[0].setDisplayname3(service.substring(0, service.length() - 1));
                     } else {
                        vos[0].setDisplayname3("");
                     }

                     if(!resultVO.isEmpty()) {
                        vos[0].setDisplayname4(resultVO.substring(0, resultVO.length() - 1));
                     } else {
                        vos[0].setDisplayname4("");
                     }

                     if(!allVOs.isEmpty()) {
                        vos[0].setDisplayname5(allVOs.substring(0, allVOs.length() - 1));
                     } else {
                        vos[0].setDisplayname5("");
                     }

                     if(!vo.isEmpty()) {
                        vos[0].setDisplayname6(vo.substring(0, vo.length() - 1));
                     } else {
                        vos[0].setDisplayname6("");
                     }
                  }
               }
            }

            if(vos != null && vos[0].getPk_factor1() != null) {
               addVOLst.setClassfactor(vos);
            }

            String var51 = "";
            if(addVOLst.getClassfactor() != null) {
               var51 = addVOLst.getClassfactor()[0].getPk_factor1();
            }

            if(vos != null && var51 != null && !"null".equals(var51) && !var51.isEmpty() && !"undefined".equals(var51)) {
               addVOLst.setPk_classfactor(vos[0].getPk_classfactor());
            } else {
               addVOLst.setClassfactor((ClassFactorVO[])null);
            }
         }

         BillRegisterVO var34 = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).getBillRegisterInfoWeb(var30, var31);
         String var35 = var34 == null?null:var34.getOrg_entity_id();
         Grid var36 = null;
         if(ArrayUtils.isEmpty(classDefineVOs)) {
            return var36;
         } else {
            ArrayList var37 = new ArrayList();
            ArrayList var38 = new ArrayList();
            ArrayList var39 = new ArrayList();
            BatchOperateVO var40 = new BatchOperateVO();
            ClassDefineVO[] var41 = classDefineVOs;
            int var43 = classDefineVOs.length;

            for(int var45 = 0; var45 < var43; ++var45) {
               ClassDefineVO var47 = var41[var45];
               if(var47.getPk_classfactor() != null && var47.getPk_classfactor().isEmpty()) {
                  var47.setPk_classfactor((String)null);
               }

               if(var47.getTs() == null) {
                  var47.setStatus(2);
               }

               if(var47.getStatus() == 2) {
                  var47.setDes_billtype(var31);
                  var47.setPk_group(var30);
                  var47.setDesdoctype(var35);
                  var37.add(var47);
               }

               if(var47.getStatus() == 1) {
                  var38.add(var47);
               }

               if(var47.getStatus() == 3) {
                  var39.add(var47);
               }
            }

            if(!var37.isEmpty()) {
               var40.setAddObjs(var37.toArray(new Object[0]));
            }

            if(!var38.isEmpty()) {
               var40.setUpdObjs(var38.toArray(new Object[0]));
            }

            if(!var39.isEmpty()) {
               var40.setDelObjs(var39.toArray(new Object[0]));
            }

            IClassDefService var42 = (IClassDefService)ServiceLocator.find(IClassDefService.class);
            BatchOperateVO var44 = var42.batchSave(var40);
            ArrayList var46 = new ArrayList();
            Object[] var48;
            int var49;
            Object var50;
            int var52;
            if(ArrayUtils.isNotEmpty(var44.getAddObjs())) {
               var48 = var44.getAddObjs();
               var49 = var48.length;

               for(var52 = 0; var52 < var49; ++var52) {
                  var50 = var48[var52];
                  var46.add((ClassDefineVO)var50);
               }
            }

            if(ArrayUtils.isNotEmpty(var44.getUpdObjs())) {
               var48 = var44.getUpdObjs();
               var49 = var48.length;

               for(var52 = 0; var52 < var49; ++var52) {
                  var50 = var48[var52];
                  var46.add((ClassDefineVO)var50);
               }
            }

            if(ArrayUtils.isNotEmpty(var44.getDelObjs())) {
               var48 = var44.getDelObjs();
               var49 = var48.length;

               for(var52 = 0; var52 < var49; ++var52) {
                  var50 = var48[var52];
                  var46.add((ClassDefineVO)var50);
               }
            }

            var36 = e.toGrid("10170404_1017040401", var46.toArray(new ClassDefineVO[0]));
            return var36;
         }
      } catch (Exception var29) {
         ExceptionUtils.wrapException(var29);
         return null;
      }
   }
}
