package nccloud.web.fip.messagelog.action;

import nc.itf.fip.msglog.IFipMsgLog;
import nc.itf.fip.opreatinglog.IBusiTypeService;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.fip.messagelogs.MessageLogVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;
import nccloud.pubitf.platform.query.INCCloudQueryService;

public class MessageLogQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String read = request.read();
      IJson json = JsonFactory.create();
      Grid result = null;
      AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(read, AccountingQueryPageInfo.class);

      try {
         String e = " 1 = 1 ";
         if(info != null && info.getQueryInfo() != null) {
            INCCloudQueryService logvos = (INCCloudQueryService)ServiceLocator.find(INCCloudQueryService.class);
            IQueryScheme operator = logvos.convertCondition(info.getQueryInfo());
            if(operator != null && operator.getWhereSQLOnly() != null) {
               e = operator.getWhereSQLOnly();
            }
         }

         MessageLogVO[] logvos1 = ((IFipMsgLog)ServiceLocator.find(IFipMsgLog.class)).queryByWhere(e);
         if(logvos1 != null && logvos1.length > 0) {
            logvos1 = ((IBusiTypeService)ServiceLocator.find(IBusiTypeService.class)).queryByMessageVOs(logvos1);
            GridOperator operator1 = new GridOperator(info.getPagecode());
            result = operator1.toGrid(logvos1);
         }
      } catch (Exception var9) {
         ExceptionUtils.wrapException(var9);
      }

      return result;
   }
}
