package nccloud.web.fip.impacfactor.action;

import nc.itf.fip.impacfactor.IImpacFactorService;
import nc.ui.bd.ref.RefPubUtil;
import nc.ui.pub.beans.constenum.DefaultConstEnum;
import nc.vo.bd.ref.RefInfoVO;
import nc.vo.fip.impacfactor.ImpacFactorVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.GridConvertProcessor;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;

public class QueryImpacfactorAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         ImpacFactorVO vo = new ImpacFactorVO();
         vo.setPk_group(pk_group);
         if(info.getOid() != null) {
            vo.setPk_systypecode(info.getOid());
         }

         ImpacFactorVO[] vos = ((IImpacFactorService)ServiceLocator.find(IImpacFactorService.class)).queryByVO(vo);
         if(vos == null) {
            return null;
         } else {
            GridConvertProcessor processor = new GridConvertProcessor();
            Grid grid = processor.convert(info.getPageCode(), vos);
            Translator translator = new Translator();
            translator.translate(grid);
            if(grid.getModel() != null && grid.getModel().getRows() != null) {
               for(int i = 0; i < grid.getModel().getRows().length; ++i) {
                  Row row = grid.getModel().getRows()[i];
                  if(row != null) {
                     Cell cell = row.getCell("refmodelname");
                     if(cell != null && cell.getValue() != null) {
                        RefInfoVO refinfoVO = RefPubUtil.getRefinfoVO((String)cell.getValue());
                        if(refinfoVO != null) {
                           DefaultConstEnum emu = new DefaultConstEnum(cell.getValue(), NCLangRes4VoTransl.getNCLangRes().getStrByID(refinfoVO.getResidPath(), refinfoVO.getResid()));
                           if(emu != null) {
                              cell.setValue(emu.getName());
                           }
                        }
                     }
                  }
               }
            }

            return grid;
         }
      } catch (Exception var16) {
         ExceptionUtils.wrapException(var16);
         return null;
      }
   }
}
