package nccloud.web.fip.impacfactor.action;

import java.util.ArrayList;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.impacfactor.IImpacFactorRefService;

public class ImpacFactorRefAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      Object refvos = new ArrayList();
      QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(str, QueryTemplateInfo4Web.class);
      if(info.getOid() != null) {
         IImpacFactorRefService service = (IImpacFactorRefService)ServiceLocator.find(IImpacFactorRefService.class);

         try {
            refvos = service.referLinkage(info.getOid());
         } catch (Exception var8) {
            ExceptionUtils.wrapException(var8);
         }
      }

      return refvos;
   }
}
