package nccloud.web.fip.formularef.action;

import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.formula.ISearchRefPathService;

public class SearchRefPathAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(str, QueryTemplateInfo4Web.class);
      String resulturl = "";
      String entityid = info.getOid();

      try {
         resulturl = ((ISearchRefPathService)ServiceLocator.find(ISearchRefPathService.class)).getRenfPath(entityid);
      } catch (BusinessException var8) {
         ExceptionUtils.wrapException(var8);
      }

      return resulturl;
   }
}
