package nccloud.web.fip.formularef.action;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.fip.pub.CloudFusionUtil;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.ui.pub.formula.manager.action.AbstractFormulaEntityAction;
import nccloud.vo.pub.formulaedit.EntityTreeData;

public class MetadataFormulaAction extends AbstractFormulaEntityAction {

   public Object doAction(IRequest request) {
      IJson json = JsonFactory.create();
      String read = request.read();
      Map jsonparam = (Map)json.fromJson(read, Map.class);
      String pk_billtype = (String)jsonparam.get("pk_billtype");
      BilltypeVO billtypeVo = null;

      try {
         billtypeVo = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltype(pk_billtype);
      } catch (BusinessException var8) {
         ExceptionUtils.wrapException(var8);
      }

      return billtypeVo != null && (billtypeVo == null || !CloudFusionUtil.isNotNCCProduct(billtypeVo.getSystemcode()) || "TX01".equalsIgnoreCase(billtypeVo.getPk_billtypecode()))?super.doAction(request):new EntityTreeData("", "", "");
   }

   public EntityTreeData ProcessEntityTreeData(EntityTreeData entitytreedata) {
      process(entitytreedata.getChildren());
      return entitytreedata;
   }

   private static void process(List childs) {
      Iterator var1 = childs.iterator();

      while(var1.hasNext()) {
         EntityTreeData et2 = (EntityTreeData)var1.next();
         if(et2.getChildren() != null && et2.getChildren().size() != 0) {
            Iterator var3 = et2.getChildren().iterator();

            while(var3.hasNext()) {
               EntityTreeData ent = (EntityTreeData)var3.next();
               et2.getInputSig().setInputSig(ent.getInputSig());
            }

            process(et2.getChildren());
            et2.setInputSig(et2.getInputSig());
         } else {
            et2.setInputSig(et2.getInputSig());
         }
      }

   }
}
