package nccloud.web.fip.fipconfig.action;

import java.util.HashMap;
import java.util.Map;
import nc.itf.fip.config.IFipConfig;
import nc.vo.fip.config.ConfigVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.GridConvertProcessor;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridFormulaHandler;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class QueryFipconfigAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         ConfigVO vo = new ConfigVO();
         if(info.getOid() != null) {
            vo.setSrc_billtype(info.getOid());
            vo.setPk_group(pk_group);
         }

         ConfigVO[] vos = ((IFipConfig)ServiceLocator.find(IFipConfig.class)).queryByVO(vo, UFBoolean.TRUE);
         if(vos != null && vos.length != 0) {
            GridConvertProcessor processor = new GridConvertProcessor();
            Grid grid = processor.convert(info.getPageCode(), vos);
            GridFormulaHandler gfh = new GridFormulaHandler(grid);
            gfh.handleLoadFormula();
            Translator translator = new Translator();
            translator.translate(grid);
            this.dealDisplay(grid, vos, pk_group, info.getOid(), (String)null);
            return grid;
         } else {
            return null;
         }
      } catch (Exception var12) {
         ExceptionUtils.wrapException(var12);
         return null;
      }
   }

   public void dealDisplay(Grid grid, ConfigVO[] vos, String pk_group, String src_billtype, String des_billtype) {
      Row[] headRows = grid.getModel().getRows();
      if(headRows != null) {
         HashMap valueMap = new HashMap();

         for(int i = 0; i < vos.length; ++i) {
            valueMap.put("leachformula", vos[i].getLeachformula());
            ITransTemplateService translateService = (ITransTemplateService)ServiceLocator.find(ITransTemplateService.class);
            Map displayShowMap = null;

            try {
               displayShowMap = translateService.convertTemplateHeadData(valueMap, pk_group, (String)null, src_billtype, des_billtype, (String)null);
            } catch (BusinessException var12) {
               ExceptionUtils.wrapBusinessException(var12.getMessage());
            }

            Cell expmessage1 = headRows[i].getCell("leachformula");
            if(expmessage1 != null && expmessage1.getValue() != null) {
               expmessage1.setDisplay((String)displayShowMap.get("leachformula"));
            }
         }
      }

   }
}
