package nccloud.web.fip.fipconfig.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nc.vo.fip.pub.ExtBillTypeVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.pubitf.fip.fipconfig.IQueryFipConfigTreeService;
import nccloud.web.fip.fipconfig.action.FipconfigNodeWapper;
import nccloud.web.fip.tree.TradeTypeTreeBuilder;
import nccloud.web.uapbd.commons.tree.ITreeNode;

public class FipconfigTreeMenuAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         IQueryFipConfigTreeService service = (IQueryFipConfigTreeService)ServiceLocator.find(IQueryFipConfigTreeService.class);
         ExtBillTypeVO[] ebtVo = service.getMenus();
         List treenodes = (new FipconfigNodeWapper(ebtVo, new TradeTypeTreeBuilder())).getTree();
         List e = this.filterNodes(treenodes);
         return e;
      } catch (Exception var6) {
         ExceptionUtils.wrapException(var6);
         return null;
      }
   }

   public List filterNodes(List treenodes) {
      ArrayList ids = new ArrayList();
      ArrayList target = new ArrayList();
      Iterator var4 = treenodes.iterator();

      ITreeNode treenode;
      while(var4.hasNext()) {
         treenode = (ITreeNode)var4.next();
         ids.add(treenode.getId());
      }

      var4 = treenodes.iterator();

      while(var4.hasNext()) {
         treenode = (ITreeNode)var4.next();
         String pid = treenode.getPid();
         if(pid == null || ids.contains(pid)) {
            target.add(treenode);
         }
      }

      return target;
   }
}
