package nccloud.web.fip.fieldreport.action;

import java.util.Iterator;
import java.util.List;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.itf.fip.report.IFipReport;
import nc.vo.fip.report.FieldReportVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.dto.fip.PageQueryDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.Conditions;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridFormulaHandler;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingPagingService;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;

public class QueryFieldreportAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         Grid result = null;
         AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(e, AccountingQueryPageInfo.class);
         String wherepart = this.getSearchSql(info);
         Integer pageSize = Integer.valueOf(info.getPageInfo().getPageSize());
         Integer pageIndex = Integer.valueOf(info.getPageInfo().getPageIndex());
         GridOperator operator;
         if(info.getAllpks() == null) {
            AccountingPagingService gfh = (AccountingPagingService)ServiceLocator.find(AccountingPagingService.class);
            PageQueryDTO translator = gfh.queryFieldBillPksByWhere(wherepart, pageSize.intValue());
            String[] length = translator == null?null:translator.getAllPKs();
            CircularlyAccessibleValueObject[] newvos = translator == null?null:translator.getCurrentHeadVOs();
            if(translator == null || length == null || length.length == 0 || newvos == null || newvos.length == 0) {
               return null;
            }

            operator = new GridOperator(info.getPagecode());
            result = operator.toGrid(newvos);
            result.getModel().setAllpks(length);
            PageInfo pageInfo = new PageInfo();
            pageInfo.setTotal(length.length);
            pageInfo.setPageSize(pageSize.intValue());
            pageInfo.setPageIndex(pageIndex.intValue());
            pageInfo.setTotalPage(this.getTotalPage(pageInfo, length.length));
            result.getModel().setPageinfo(pageInfo);
         } else {
            FieldReportVO[] var16 = ((IFipReport)ServiceLocator.find(IFipReport.class)).queryFieldReport(wherepart);
            if(var16 == null) {
               return null;
            }

            int var18 = pageIndex.intValue() * pageSize.intValue();
            int var20 = var16.length - var18 > pageSize.intValue()?pageSize.intValue():var16.length - var18;
            FieldReportVO[] var21 = new FieldReportVO[var20];

            for(int var22 = 0; var22 < var20; ++var22) {
               var21[var22] = var16[var18 + var22];
            }

            operator = new GridOperator(info.getPagecode());
            result = operator.toGrid(var21);
         }

         GridFormulaHandler var17 = new GridFormulaHandler(result);
         var17.handleLoadFormula();
         Translator var19 = new Translator();
         var19.translate(result);
         return result;
      } catch (Exception var15) {
         ExceptionUtils.wrapException(var15.getMessage(), var15);
         return null;
      }
   }

   private int getTotalPage(PageInfo pageInfo, int len) {
      int size = pageInfo.getPageSize();
      boolean total = false;
      int total1;
      if(len % size == 0) {
         total1 = len / size;
      } else {
         total1 = len / size + 1;
      }

      return total1;
   }

   public String getSearchSql(AccountingQueryPageInfo info) {
      List conditions = info.getConditions();
      String sqlWhere = "1=1";
      if(conditions != null && conditions.size() > 0) {
         Iterator var4 = conditions.iterator();

         while(var4.hasNext()) {
            Conditions con = (Conditions)var4.next();
            if("des_billtype".equals(con.getField()) || "src_billtype".equals(con.getField())) {
               String[] pks = con.getValue().getFirstvalue().split(",");
               if(pks != null && pks.length > 0) {
                  String srcCode = "";
                  List billtypes = null;

                  try {
                     billtypes = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).queryByPks(pks);
                  } catch (BusinessException var10) {
                     ExceptionUtils.wrapException(var10.getMessage(), var10);
                  }

                  int i;
                  if(billtypes != null && billtypes.size() > 0) {
                     for(i = 0; i < billtypes.size(); ++i) {
                        if(i == 0) {
                           srcCode = ((BilltypeVO)billtypes.get(i)).getPk_billtypecode();
                        } else {
                           srcCode = ((BilltypeVO)billtypes.get(i)).getPk_billtypecode();
                        }
                     }
                  } else {
                     for(i = 0; i < pks.length; ++i) {
                        if(i == 0) {
                           srcCode = pks[i];
                        } else {
                           srcCode = pks[i];
                        }
                     }
                  }

                  con.getField();
                  sqlWhere = srcCode;
               }
            }
         }
      }

      return sqlWhere;
   }
}
