package nccloud.web.fip.docmapimport.action;

import nc.itf.fip.docmap.IFipDocMapImport;
import nc.vo.fip.docmap.DocmapImportVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.GridConvertProcessor;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;

public class QueryDocmapimportAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         DocmapImportVO vo = new DocmapImportVO();
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         vo.setPk_group(pk_group);
         if(info.getOid() != null) {
            vo.setPk_org(info.getOid());
         }

         DocmapImportVO[] vos = ((IFipDocMapImport)ServiceLocator.find(IFipDocMapImport.class)).queryByVO(vo);
         if(vos == null) {
            return null;
         } else {
            DocmapImportVO[] processor = vos;
            int grid = vos.length;

            for(int translator = 0; translator < grid; ++translator) {
               DocmapImportVO docmapImportVO = processor[translator];
               docmapImportVO.setPk_temp(docmapImportVO.getPk_docmap());
            }

            GridConvertProcessor var14 = new GridConvertProcessor();
            Grid var15 = var14.convert(info.getPageCode(), vos);
            Translator var13 = new Translator();
            var13.translate(var15);
            this.prepareTranslator(var15);
            return var15;
         }
      } catch (Exception var12) {
         ExceptionUtils.wrapException(var12);
         return null;
      }
   }

   public void prepareTranslator(Grid grid) {
      Row[] rows = grid.getModel().getRows();
      Row[] var3 = rows;
      int var4 = rows.length;

      for(int var5 = 0; var5 < var4; ++var5) {
         Row row = var3[var5];
         int srctype = ((Integer)row.getCell("srctype").getValue()).intValue();
         if(srctype == 2 || srctype == 3) {
            row.getCell("pk_docmap").setDisplay(row.getCell("pk_temp").getDisplay());
         }
      }

   }
}
