package nccloud.web.fip.docconvertmap.action;

import nc.vo.fip.docmap.DocMapVO;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nccloud.dto.fip.PageQueryDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingPagingService;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;

public class QueryDocmapAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         Grid result = null;
         AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(e, AccountingQueryPageInfo.class);
         DocMapVO vo = new DocMapVO();
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         vo.setPk_group(pk_group);
         if(info.getAllpks() == null) {
            Integer translator = Integer.valueOf(info.getPageInfo().getPageSize());
            Integer vos = Integer.valueOf(info.getPageInfo().getPageIndex());
            AccountingPagingService operator = (AccountingPagingService)ServiceLocator.find(AccountingPagingService.class);
            PageQueryDTO pageResult = operator.queryWebPageBillPksByWhere(vo, translator.intValue());
            String[] pks = pageResult == null?null:pageResult.getAllPKs();
            CircularlyAccessibleValueObject[] currentHeadVOs = pageResult == null?null:pageResult.getCurrentHeadVOs();
            if(pageResult == null || pks == null || pks.length == 0 || currentHeadVOs == null || currentHeadVOs.length == 0) {
               return null;
            }

            GridOperator operator1 = new GridOperator(info.getPagecode());
            result = operator1.toGrid(currentHeadVOs);
            result.getModel().setAllpks(pks);
            PageInfo pageInfo = new PageInfo();
            pageInfo.setTotal(pks.length);
            pageInfo.setPageSize(translator.intValue());
            pageInfo.setPageIndex(vos.intValue());
            pageInfo.setTotalPage(this.getTotalPage(pageInfo, pks.length));
            result.getModel().setPageinfo(pageInfo);
         } else {
            AccountingPagingService translator1 = (AccountingPagingService)ServiceLocator.find(AccountingPagingService.class);
            DocMapVO[] vos1 = translator1.queryDocmapsByPksWhere(info.getAllpks());
            if(vos1.length == 0) {
               return null;
            }

            GridOperator operator2 = new GridOperator(info.getPagecode());
            result = operator2.toGrid(vos1);
         }

         Translator translator2 = new Translator();
         translator2.translate(result);
         return result;
      } catch (Exception var16) {
         ExceptionUtils.wrapException(var16);
         return null;
      }
   }

   private int getTotalPage(PageInfo pageInfo, int len) {
      int size = pageInfo.getPageSize();
      boolean total = false;
      int total1;
      if(len % size == 0) {
         total1 = len / size;
      } else {
         total1 = len / size + 1;
      }

      return total1;
   }
}
