package nccloud.web.fip.docconvertmap.action;

import java.util.HashMap;
import java.util.Map;
import nc.vo.fip.docmap.DocmapImportVO;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.processor.refgrid.RefQueryInfo;
import nccloud.framework.web.ui.meta.RefMeta;
import nccloud.web.refer.DefaultGridRefAction;

public class DocmapimportRef extends DefaultGridRefAction {

   public RefMeta getRefMeta(RefQueryInfo refQueryInfo) {
      RefMeta meta = new RefMeta();
      meta.setCodeField("docmapcode");
      meta.setNameField("docmapname");
      meta.setPkField("pk_docmapimport");
      meta.setTableName(DocmapImportVO.getDefaultTableName());
      meta.setMutilLangNameRef(true);
      return meta;
   }

   public String getExtraSql(RefQueryInfo refQueryInfo, RefMeta refMeta) {
      String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
      String wheresql = pk_group;
      Map param = refQueryInfo.getQueryCondition();
      Object param1 = param == null?new HashMap():param;
      String pk_org = (String)((Map)param1).get("pk_org");
      if(StringUtils.isNotEmpty(pk_org)) {
         wheresql = pk_org;
      }

      return wheresql;
   }

   public String getOrderSql(RefQueryInfo refQueryInfo, RefMeta refMeta) {
      return " order by docmapcode";
   }
}
