package nccloud.web.fip.docconvertmap.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nc.itf.fip.docmap.IFipDocMap;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class DocmapDeleteAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String read = request.read();
      IJson json = JsonFactory.create();
      Map param = (Map)json.fromJson(read, HashMap.class);
      ArrayList pks = (ArrayList)param.get("pk");
      IFipDocMap service = (IFipDocMap)ServiceLocator.find(IFipDocMap.class);

      try {
         service.delete((String[])pks.toArray(new String[pks.size()]));
      } catch (BusinessException var8) {
         ExceptionUtils.wrapException(var8);
      }

      return null;
   }
}
