package nccloud.web.fip.docconvertmap.action;

import nc.itf.fip.docmap.IFipDocMap;
import nc.vo.fip.docmap.DocMapBodyVO;
import nc.vo.fip.docmap.DocMapVO;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.BillCardOperator;
import nccloud.framework.web.ui.pattern.billcard.SpecilAggBill;

public class DocmapAddsaveAction implements ICommonAction {

   public Object doAction(IRequest request) {
      BillCardOperator operator = new BillCardOperator();
      SpecilAggBill spvo = (SpecilAggBill)operator.toBill(request);
      String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
      DocMapVO pvo = (DocMapVO)spvo.getHead();
      pvo.setPk_group(pk_group);
      pvo.setDr(Integer.valueOf(0));
      DocMapBodyVO[] cvo = (DocMapBodyVO[])spvo.getBodys();
      pvo.setMapvalues(cvo);
      DocMapVO result = null;
      IFipDocMap service = (IFipDocMap)ServiceLocator.find(IFipDocMap.class);

      try {
         result = service.insert(pvo);
      } catch (BusinessException var13) {
         ExceptionUtils.wrapException(var13);
      }

      SpecilAggBill newAggBill = new SpecilAggBill();
      DocMapVO resultvo = (DocMapVO)result;
      DocMapBodyVO[] childvo = null;
      if(resultvo != null) {
         childvo = resultvo.getMapvalues();
      }

      if(childvo != null) {
         resultvo.setMapvalues((DocMapBodyVO[])null);
      }

      newAggBill.setHead(resultvo);
      newAggBill.setBodys(childvo);
      BillCard retcard = operator.toCard(newAggBill);
      return retcard;
   }
}
