package nccloud.web.fip.classdefreport.action;

import nc.itf.fip.report.IFipReport;
import nc.vo.fip.report.ClassDefReportVO;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nccloud.dto.fip.PageQueryDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.Conditions;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridFormulaHandler;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingPagingService;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;

public class QueryClassdefreportAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         Grid result = null;
         AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(e, AccountingQueryPageInfo.class);
         String wherepart = this.getSearchSql(info);
         Integer pageSize = Integer.valueOf(info.getPageInfo().getPageSize());
         Integer pageIndex = Integer.valueOf(info.getPageInfo().getPageIndex());
         if(info.getAllpks() == null) {
            AccountingPagingService gfh = (AccountingPagingService)ServiceLocator.find(AccountingPagingService.class);
            PageQueryDTO translator = gfh.queryWebPageBillPksByWhere(wherepart, pageSize.intValue());
            String[] size = translator == null?null:translator.getAllPKs();
            CircularlyAccessibleValueObject[] length = translator == null?null:translator.getCurrentHeadVOs();
            if(translator == null || size == null || size.length == 0 || length == null || length.length == 0) {
               return null;
            }

            GridOperator newvos = new GridOperator(info.getPagecode());
            result = newvos.toGrid(length);
            result.getModel().setAllpks(size);
            PageInfo operator = new PageInfo();
            operator.setTotal(size.length);
            operator.setPageSize(pageSize.intValue());
            operator.setPageIndex(pageIndex.intValue());
            operator.setTotalPage(this.getTotalPage(operator, size.length));
            result.getModel().setPageinfo(operator);
         } else {
            IFipReport var16 = (IFipReport)ServiceLocator.find(IFipReport.class);
            ClassDefReportVO[] var18 = var16.queryClassDefReport(wherepart);
            if(var18.length == 0) {
               return null;
            }

            int var20 = pageIndex.intValue() * pageSize.intValue();
            int var21 = var18.length - var20 - pageSize.intValue() > 0?pageSize.intValue():var18.length - var20;
            ClassDefReportVO[] var22 = new ClassDefReportVO[var21];

            for(int var23 = 0; var23 < var21; ++var23) {
               var22[var23] = var18[var20 + var23];
            }

            GridOperator var24 = new GridOperator(info.getPagecode());
            result = var24.toGrid(var22);
         }

         GridFormulaHandler var17 = new GridFormulaHandler(result);
         var17.handleLoadFormula();
         Translator var19 = new Translator();
         var19.translate(result);
         return result;
      } catch (Exception var15) {
         ExceptionUtils.wrapException(var15);
         return null;
      }
   }

   private int getTotalPage(PageInfo pageInfo, int len) {
      int size = pageInfo.getPageSize();
      boolean total = false;
      int total1;
      if(len % size == 0) {
         total1 = len / size;
      } else {
         total1 = len / size + 1;
      }

      return total1;
   }

   public String getSearchSql(AccountingQueryPageInfo info) {
      String sqlwhere = "1=1";
      if(info.getConditions() != null && info.getConditions().size() > 0) {
         for(int i = 0; i < info.getConditions().size(); ++i) {
            Conditions element = (Conditions)info.getConditions().get(i);
            String field = null;
            String pkorgs;
            if(element.getField().equals("src_system")) {
               field = element.getValue().getFirstvalue();
               pkorgs = this.addSlash(field);
               sqlwhere = pkorgs;
            } else if(element.getField().equals("des_billtype")) {
               field = element.getValue().getFirstvalue();
               if(field != null && field.contains("DL")) {
                  field = field.replaceAll("DL", "C0,NRESA03,CCA02,ICA03");
               }

               pkorgs = this.addSlash(field);
               sqlwhere = pkorgs;
            } else if(element.getField().equals("displaycode")) {
               field = element.getValue().getFirstvalue();
               sqlwhere = field;
            } else if(element.getField().equals("pk_org")) {
               field = element.getValue().getFirstvalue();
               String[] var13 = field.split(",");
               String pieceSql = "(select  pk_org from org_orgs  where 11=11 and ( ";
               boolean flag = false;
               String[] var9 = var13;
               int var10 = var13.length;

               for(int var11 = 0; var11 < var10; ++var11) {
                  String pkorg = var9[var11];
                  if(!flag) {
                     pieceSql = pkorg;
                  }
               }

               sqlwhere = pieceSql;
            }
         }
      }

      return sqlwhere;
   }

   public String addSlash(String field) {
      String afterfield = "";
      if(!"".equals(field) || field != null) {
         String[] index = field.split(",");
         String[] var4 = index;
         int var5 = index.length;

         for(int var6 = 0; var6 < var5; ++var6) {
            String string = var4[var6];
            afterfield = string;
         }
      }

      int var8 = afterfield.lastIndexOf(",");
      return afterfield.substring(0, var8);
   }
}
