package nccloud.web.fip.classdefgroup.action;

import java.util.ArrayList;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.vo.fip.pub.ExtBillTypeVO;
import nc.vo.fip.pub.FipBaseDataProxy;
import nc.vo.sm.funcreg.ModuleVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.web.fip.classdefgroup.action.ClassdefTreeNodeWapper;

public class ClassdefQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         ArrayList array = new ArrayList();
         String pk_group = InvocationInfoProxy.getInstance().getGroupId();
         ModuleVO[] systems = FipBaseDataProxy.getAllFipSystemsFilterNoChild(pk_group);
         if(systems != null) {
            ModuleVO[] wapper = systems;
            int var7 = systems.length;

            for(int var8 = 0; var8 < var7; ++var8) {
               ModuleVO system = wapper[var8];
               array.add(new ExtBillTypeVO(system));
            }
         }

         if(array.size() > 0) {
            ExtBillTypeVO[] e = new ExtBillTypeVO[array.size()];
            array.toArray(e);
         }

         ClassdefTreeNodeWapper var11 = new ClassdefTreeNodeWapper((ExtBillTypeVO[])array.toArray(new ExtBillTypeVO[0]));
         return var11.getTree();
      } catch (Exception var10) {
         ExceptionUtils.wrapException(var10);
         return null;
      }
   }
}
