package nccloud.web.fip.classdefgroup.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import nc.itf.fip.classdef.IClassDefService;
import nc.itf.fip.impacfactor.IImpacFactorService;
import nc.vo.bd.pub.BDCacheQueryUtil;
import nc.vo.fip.billregister.BillRegisterVO;
import nc.vo.fip.classdef.ClassDefineVO;
import nc.vo.fip.classdef.ClassFactorVO;
import nc.vo.fip.docview.DocViewListVO;
import nc.vo.fip.docview.DocViewVO;
import nc.vo.fip.impacfactor.ImpacFactorVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.org.OrgVO;
import nc.vo.org.SetOfBookVO;
import nccloud.dto.fip.docview.DocTranslateDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.pattern.GridConvertor;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billgrid.BillGrid;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.classdef.IWebModuleClassdefService;
import nccloud.pubitf.fip.docview.IDocViewListQuery;
import nccloud.web.fip.classdefgroup.action.QryAndSaveInfoVo;
import nccloud.web.fip.docview.action.DocViewGridConvertUtil;

public class ClassdefListQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         Object currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq().intValue();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         String pk_system = info.getOid();
         QryAndSaveInfoVo infod = (QryAndSaveInfoVo)json.fromJson(e, QryAndSaveInfoVo.class);
         String con = infod.getPagecode();
         String[] cons = con.split(",");
         ClassDefineVO classDefineVO = infod.getClassDefineVO();
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         ClassDefineVO vo = new ClassDefineVO();
         vo.setPk_group(pk_group);
         vo.setPk_org(cons[3]);
         vo.setDes_billtype(cons[2]);
         BillRegisterVO billRegisterVO = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).getBillRegisterInfoWeb(pk_group, cons[2]);
         String desdoctype = null;
         desdoctype = billRegisterVO == null?null:billRegisterVO.getClass_entity_id();
         vo.setDesdoctype(desdoctype);
         if(info.getOid() != null) {
            vo.setSrc_system(info.getOid());
         } else {
            vo.setSrc_system(classDefineVO.getSrc_system());
         }

         ClassDefineVO[] vos = ((IClassDefService)ServiceLocator.find(IClassDefService.class)).queryByVO(vo);
         if(vos == null) {
            return pk_group;
         } else {
            DocViewListVO[] viewvos = null;
            DocViewVO[] doviewVos = null;
            if(classDefineVO != null) {
               BillRegisterVO convertor1 = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).getBillRegisterInfoWeb(pk_group, classDefineVO.getDes_billtype());
               String grid1 = null;
               grid1 = convertor1 == null?null:convertor1.getClass_entity_id();
               classDefineVO.setDesdoctype(grid1);
               viewvos = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).doQuerDocViewListVO(classDefineVO);
            } else {
               viewvos = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).doQuerDocViewListVO(vos[0]);
            }

            if(viewvos != null && viewvos.length > 0) {
               doviewVos = viewvos[0].getClassviews();
            }

            GridConvertor var45 = new GridConvertor();
            Grid var46 = var45.toGrid("classdefine", vos);
            Grid grid2 = null;
            if(doviewVos != null && doviewVos.length > 0) {
               grid2 = DocViewGridConvertUtil.toGridForDocView(Arrays.asList(viewvos), viewvos[0].getDesdocid(), "classviews");
            }

            BillGrid bgrid = new BillGrid();
            bgrid.setHead(var46);
            bgrid.setBody(grid2);
            bgrid.setPageid(cons[0]);
            Translator translator = new Translator();
            translator.translate(bgrid);
            String desdocid = "";
            IImpacFactorService ip = (IImpacFactorService)ServiceLocator.find(IImpacFactorService.class);
            ImpacFactorVO qvo = new ImpacFactorVO();
            qvo.setPk_group(pk_group);
            qvo.setPk_systypecode(pk_system);
            ImpacFactorVO[] factors = ip.queryByVO(qvo);
            HashMap facmap = new HashMap();
            int dto;
            int docNameMap;
            if(factors != null) {
               ImpacFactorVO[] params = factors;
               dto = factors.length;

               for(docNameMap = 0; docNameMap < dto; ++docNameMap) {
                  ImpacFactorVO pks = params[docNameMap];
                  facmap.put(pks.getPk_factor(), pks.getEntityid());
               }
            }

            ClassDefineVO[] var47 = vos;
            dto = vos.length;

            for(docNameMap = 0; docNameMap < dto; ++docNameMap) {
               ClassDefineVO var50 = var47[docNameMap];
               ClassFactorVO[] paraMap = var50.getClassfactor();
               if(paraMap != null) {
                  if(facmap.containsKey(paraMap[0].getPk_factor1())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor1());
                  }

                  if(facmap.containsKey(paraMap[0].getPk_factor2())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor2());
                  }

                  if(facmap.containsKey(paraMap[0].getPk_factor3())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor3());
                  }

                  if(facmap.containsKey(paraMap[0].getPk_factor4())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor4());
                  }

                  if(facmap.containsKey(paraMap[0].getPk_factor5())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor5());
                  }

                  if(facmap.containsKey(paraMap[0].getPk_factor6())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor6());
                  }

                  if(facmap.containsKey(paraMap[0].getPk_factor7())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor7());
                  }

                  if(facmap.containsKey(paraMap[0].getPk_factor8())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor8());
                  }

                  if(facmap.containsKey(paraMap[0].getPk_factor9())) {
                     desdocid = (String)facmap.get(paraMap[0].getPk_factor9());
                  }
               }
            }

            if(!"".equals(desdocid)) {
               desdocid = desdocid.substring(0, desdocid.length() - 1);
            }

            ArrayList var48 = new ArrayList();
            DocTranslateDTO var49 = new DocTranslateDTO();
            Object var51 = new HashMap();
            HashSet var52 = new HashSet();
            HashMap var53 = new HashMap();
            HashSet defpks = new HashSet();
            ClassDefineVO[] sbvo = vos;
            int orgvo = vos.length;

            int maporg;
            for(maporg = 0; maporg < orgvo; ++maporg) {
               ClassDefineVO grids = sbvo[maporg];
               if(grids != null) {
                  var52.add(grids.getPk_org());
                  var52.add(grids.getPk_classmainprop());
                  if(grids.getDefaultvalue() != null) {
                     defpks.add(grids.getDefaultvalue());
                  }
               }
            }

            var53.put(desdoctype, defpks);
            Row[] var54 = var46.getModel().getRows();
            orgvo = var54.length;

            for(maporg = 0; maporg < orgvo; ++maporg) {
               Row var58 = var54[maporg];
               if(var58.getValues().get("pk_classmainprop.pk_org") != null && ((Cell)var58.getValues().get("pk_classmainprop.pk_org")).getDisplay() != null) {
                  var52.add(((Cell)var58.getValues().get("pk_classmainprop.pk_org")).getDisplay().toString());
               }
            }

            var52.add("GLOBLE00000000000000");
            Object[] var55 = BDCacheQueryUtil.queryVOsByIDs(SetOfBookVO.class, "pk_setofbook", (String[])var52.toArray(new String[0]), (String[])null);
            Object[] var56 = BDCacheQueryUtil.queryVOsByIDs(OrgVO.class, "pk_org", (String[])var52.toArray(new String[0]), (String[])null);
            HashMap var57 = new HashMap();
            Object[] var59 = var55;
            int row = var55.length;

            int cell;
            Object cell1;
            for(cell = 0; cell < row; ++cell) {
               cell1 = var59[cell];
               if((SetOfBookVO)cell1 != null) {
                  if(currLangIndex == 1) {
                     var57.put(((SetOfBookVO)cell1).getPk_setofbook(), ((SetOfBookVO)cell1).getAttributeValue("name") == null?"":((SetOfBookVO)cell1).getAttributeValue("name").toString());
                  } else {
                     var57.put(((SetOfBookVO)cell1).getPk_setofbook(), ((SetOfBookVO)cell1).getAttributeValue((String)currLangIndex) == null?(((SetOfBookVO)cell1).getAttributeValue("name") == null?"":((SetOfBookVO)cell1).getAttributeValue("name").toString()):((SetOfBookVO)cell1).getAttributeValue((String)currLangIndex).toString());
                  }
               }
            }

            var59 = var56;
            row = var56.length;

            for(cell = 0; cell < row; ++cell) {
               cell1 = var59[cell];
               if((OrgVO)cell1 != null) {
                  if(currLangIndex == true) {
                     var57.put(((OrgVO)cell1).getPk_org(), ((OrgVO)cell1).getAttributeValue("name") == null?"":((OrgVO)cell1).getAttributeValue("name").toString());
                  } else {
                     var57.put(((OrgVO)cell1).getPk_org(), ((OrgVO)cell1).getAttributeValue((String)currLangIndex) == null?(((OrgVO)cell1).getAttributeValue("name") == null?"":((OrgVO)cell1).getAttributeValue("name").toString()):((OrgVO)cell1).getAttributeValue((String)currLangIndex).toString());
                  }
               }
            }

            var49.setId(desdoctype);
            var49.setPks(defpks);
            var48.add(var49);
            if(var48.size() > 0) {
               var51 = ((IDocViewListQuery)ServiceLocator.find(IDocViewListQuery.class)).getDocNameByPKForShow((DocTranslateDTO[])var48.toArray(new DocTranslateDTO[0]));
            }

            if(var46.getModel() != null && var46.getModel().getRows() != null) {
               for(int var60 = 0; var60 < var46.getModel().getRows().length; ++var60) {
                  Row var61 = var46.getModel().getRows()[var60];
                  Cell var63 = new Cell();
                  if(vos != null && vos[var60].getClassfactor() != null && vos[var60].getClassfactor().length > 0) {
                     if(currLangIndex == true) {
                        var63.setDisplay((String)vos[var60].getClassfactor()[0].getAttributeValue("displayname"));
                     } else {
                        String var64 = vos[var60].getClassfactor()[0].getAttributeValue((String)currLangIndex) == null?(String)vos[var60].getClassfactor()[0].getAttributeValue("displayname"):(String)vos[var60].getClassfactor()[0].getAttributeValue((String)currLangIndex);
                        var63.setDisplay(var64);
                     }
                  }

                  var61.getValues().put("pk_classfactor", var63);
                  Cell var65 = new Cell();
                  if(var61.getValues().get("pk_org") != null) {
                     if(((Cell)var61.getValues().get("pk_org")).getValue() == null) {
                        var65.setValue(((Cell)var61.getValues().get("pk_org")).getValue());
                        var65.setDisplay((String)var57.get("GLOBLE00000000000000"));
                     } else {
                        var65.setValue(((Cell)var61.getValues().get("pk_org")).getValue());
                        var65.setDisplay((String)var57.get(((Cell)var61.getValues().get("pk_org")).getValue()));
                     }
                  }

                  var61.getValues().put("pk_org", var65);
                  Cell cell2 = new Cell();
                  if(var61.getValues().get("pk_classmainprop.pk_org") != null) {
                     if(((Cell)var61.getValues().get("pk_classmainprop.pk_org")).getValue() == null) {
                        cell2.setValue(((Cell)var61.getValues().get("pk_classmainprop.pk_org")).getValue());
                        cell2.setDisplay((String)var57.get("GLOBLE00000000000000"));
                     } else {
                        cell2.setValue(((Cell)var61.getValues().get("pk_classmainprop.pk_org")).getValue());
                        cell2.setDisplay((String)var57.get(((Cell)var61.getValues().get("pk_classmainprop.pk_org")).getValue()));
                     }
                  }

                  var61.getValues().put("pk_classmainprop.pk_org", cell2);
                  Cell cell3 = new Cell();
                  if(var61.getValues().get("defaultvalue") != null) {
                     cell3.setValue(((Cell)var61.getValues().get("defaultvalue")).getValue());
                     ((Cell)var51).setDisplay((String)desdoctype.get(((Cell)var61.getValues().get("defaultvalue")).getValue()));
                  }

                  var61.getValues().put("defaultvalue", cell3);
                  Cell cell4 = new Cell();
                  cell4.setValue(desdocid);
                  var61.getValues().put("pk_classfactor2", cell4);
               }
            }

            ArrayList var62 = new ArrayList();
            var62.add(var46);
            var62.add(grid2);
            return var62;
         }
      } catch (Exception var44) {
         ExceptionUtils.wrapException(var44);
         return null;
      }
   }
}
