package nccloud.web.fip.classdef.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import nc.itf.fip.classdef.IClassDefService;
import nc.vo.bd.pub.BDCacheQueryUtil;
import nc.vo.fip.billregister.BillRegisterVO;
import nc.vo.fip.classdef.ClassDefineVO;
import nc.vo.fip.docview.DocViewListVO;
import nc.vo.fip.docview.DocViewVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.org.AccbookVO;
import nc.vo.org.OrgVO;
import nc.vo.org.SetOfBookVO;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.fip.docview.DocTranslateDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.pattern.GridConvertor;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billgrid.BillGrid;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.classdef.IWebModuleClassdefService;
import nccloud.pubitf.fip.docview.IDocViewListQuery;
import nccloud.web.fip.classdef.action.QryAndSaveInfoVo;
import nccloud.web.fip.docview.action.DocViewGridConvertUtil;

public class ClassdefListQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         Object currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq().intValue();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         QryAndSaveInfoVo infod = (QryAndSaveInfoVo)json.fromJson(e, QryAndSaveInfoVo.class);
         String con = infod.getPagecode();
         String[] cons = con.split(",");
         ClassDefineVO classDefineVO = infod.getClassDefineVO();
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         ClassDefineVO vo = new ClassDefineVO();
         vo.setPk_group(pk_group);
         vo.setPk_org(cons[3]);
         vo.setDes_billtype(cons[2]);
         if("CM02".equals(vo.getDes_billtype()) && cons.length == 5) {
            vo.setDesfactor1(cons[4]);
         }

         BillRegisterVO billRegisterVO = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).getBillRegisterInfoWeb(pk_group, cons[2]);
         String desdoctype = null;
         desdoctype = billRegisterVO == null?null:billRegisterVO.getClass_entity_id();
         vo.setDesdoctype(desdoctype);
         if(info.getOid() != null) {
            vo.setSrc_system(info.getOid());
         } else {
            vo.setSrc_system(classDefineVO.getSrc_system());
         }

         ClassDefineVO[] vos = ((IClassDefService)ServiceLocator.find(IClassDefService.class)).queryByVO(vo);
         if(vos == null) {
            return null;
         } else {
            DocViewVO[] doviewVos = null;
            DocViewListVO[] viewvos;
            if(classDefineVO != null) {
               BillRegisterVO convertor1 = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).getBillRegisterInfoWeb(pk_group, classDefineVO.getDes_billtype());
               String grid1 = null;
               grid1 = convertor1 == null?null:convertor1.getClass_entity_id();
               classDefineVO.setDesdoctype(grid1);
               viewvos = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).doQuerDocViewListVO(classDefineVO);
            } else {
               viewvos = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).doQuerDocViewListVO(vos[0]);
            }

            if(viewvos != null && viewvos.length > 0) {
               doviewVos = viewvos[0].getClassviews();
            }

            GridConvertor var42 = new GridConvertor();
            Grid var43 = var42.toGrid("classdefine", vos);
            Grid grid2 = null;
            if(doviewVos != null && doviewVos.length > 0) {
               grid2 = DocViewGridConvertUtil.toGridForDocView(Arrays.asList(viewvos), viewvos[0].getDesdocid(), "classviews");
            }

            BillGrid bgrid = new BillGrid();
            bgrid.setHead(var43);
            bgrid.setBody(grid2);
            bgrid.setPageid("10170406_1017040601");
            Translator translator = new Translator();
            translator.translate(bgrid);
            HashSet pks = new HashSet();
            HashMap paraMap = new HashMap();
            HashSet defpks = new HashSet();
            ClassDefineVO[] sbvo = vos;
            int orgvo = vos.length;

            int maporg;
            for(maporg = 0; maporg < orgvo; ++maporg) {
               ClassDefineVO params = sbvo[maporg];
               if(params != null) {
                  pks.add(params.getPk_org());
                  pks.add(params.getPk_classmainprop());
                  if(params.getDefaultvalue() != null) {
                     defpks.add(params.getDefaultvalue());
                  }
               }
            }

            paraMap.put(desdoctype, defpks);
            Row[] var44 = var43.getModel().getRows();
            orgvo = var44.length;

            for(maporg = 0; maporg < orgvo; ++maporg) {
               Row var48 = var44[maporg];
               if(var48.getValues().get("pk_classmainprop.pk_org") != null && ((Cell)var48.getValues().get("pk_classmainprop.pk_org")).getDisplay() != null) {
                  pks.add(((Cell)var48.getValues().get("pk_classmainprop.pk_org")).getDisplay().toString());
               }
            }

            pks.add("GLOBLE00000000000000");
            Object[] var45 = BDCacheQueryUtil.queryVOsByIDs(SetOfBookVO.class, "pk_setofbook", (String[])pks.toArray(new String[0]), (String[])null);
            Object[] var46 = BDCacheQueryUtil.queryVOsByIDs(OrgVO.class, "pk_org", (String[])pks.toArray(new String[0]), (String[])null);
            HashMap var47 = new HashMap();
            Object[] var49 = var45;
            int dto = var45.length;

            int docNameMap;
            Object accBookMap;
            for(docNameMap = 0; docNameMap < dto; ++docNameMap) {
               accBookMap = var49[docNameMap];
               if((SetOfBookVO)accBookMap != null) {
                  if(currLangIndex == 1) {
                     var47.put(((SetOfBookVO)accBookMap).getPk_setofbook(), ((SetOfBookVO)accBookMap).getAttributeValue("name") == null?"":((SetOfBookVO)accBookMap).getAttributeValue("name").toString());
                  } else {
                     var47.put(((SetOfBookVO)accBookMap).getPk_setofbook(), ((SetOfBookVO)accBookMap).getAttributeValue((String)currLangIndex) == null?(((SetOfBookVO)accBookMap).getAttributeValue("name") == null?"":((SetOfBookVO)accBookMap).getAttributeValue("name").toString()):((SetOfBookVO)accBookMap).getAttributeValue((String)currLangIndex).toString());
                  }
               }
            }

            var49 = var46;
            dto = var46.length;

            for(docNameMap = 0; docNameMap < dto; ++docNameMap) {
               accBookMap = var49[docNameMap];
               if((OrgVO)accBookMap != null) {
                  if(currLangIndex == true) {
                     var47.put(((OrgVO)accBookMap).getPk_org(), ((OrgVO)accBookMap).getAttributeValue("name") == null?"":((OrgVO)accBookMap).getAttributeValue("name").toString());
                  } else {
                     var47.put(((OrgVO)accBookMap).getPk_org(), ((OrgVO)accBookMap).getAttributeValue((String)currLangIndex) == null?(((OrgVO)accBookMap).getAttributeValue("name") == null?"":((OrgVO)accBookMap).getAttributeValue("name").toString()):((OrgVO)accBookMap).getAttributeValue((String)currLangIndex).toString());
                  }
               }
            }

            ArrayList var50 = new ArrayList();
            DocTranslateDTO var51 = new DocTranslateDTO();
            var51.setId(desdoctype);
            var51.setPks(defpks);
            var50.add(var51);
            Map var52 = ((IDocViewListQuery)ServiceLocator.find(IDocViewListQuery.class)).getDocNameByPKForShow((DocTranslateDTO[])var50.toArray(new DocTranslateDTO[0]));
            HashMap var53 = new HashMap();
            if(StringUtils.isNotEmpty(vo.getDesfactor1())) {
               String[] grids = vo.getDesfactor1().split(",");
               Object[] row = BDCacheQueryUtil.queryVOsByIDs(AccbookVO.class, "pk_accbook", grids, (String[])null);
               if(row != null) {
                  Object[] cell = row;
                  int cell1 = row.length;

                  for(int cell2 = 0; cell2 < cell1; ++cell2) {
                     Object cell3 = cell[cell2];
                     AccbookVO cell4 = (AccbookVO)cell3;
                     var53.put(cell4.getPk_accbook(), cell4);
                  }
               }
            }

            if(var43.getModel() != null && var43.getModel().getRows() != null) {
               for(int var54 = 0; var54 < var43.getModel().getRows().length; ++var54) {
                  Row var56 = var43.getModel().getRows()[var54];
                  Cell var57 = new Cell();
                  if(vos != null && vos[var54].getClassfactor() != null && vos[var54].getClassfactor().length > 0) {
                     if(currLangIndex == true) {
                        var57.setDisplay((String)vos[var54].getClassfactor()[0].getAttributeValue("displayname"));
                     } else {
                        String var58 = vos[var54].getClassfactor()[0].getAttributeValue((String)currLangIndex) == null?(String)vos[var54].getClassfactor()[0].getAttributeValue("displayname"):(String)vos[var54].getClassfactor()[0].getAttributeValue((String)currLangIndex);
                        var57.setDisplay(var58);
                     }
                  }

                  var56.getValues().put("pk_classfactor", var57);
                  Cell var59 = new Cell();
                  if(var56.getValues().get("pk_org") != null) {
                     if(((Cell)var56.getValues().get("pk_org")).getValue() == null) {
                        var59.setValue(((Cell)var56.getValues().get("pk_org")).getValue());
                        var59.setDisplay((String)var47.get("GLOBLE00000000000000"));
                     } else {
                        var59.setValue(((Cell)var56.getValues().get("pk_org")).getValue());
                        var59.setDisplay((String)var47.get(((Cell)var56.getValues().get("pk_org")).getValue()));
                     }
                  }

                  var56.getValues().put("pk_org", var59);
                  Cell var60 = new Cell();
                  if(var56.getValues().get("pk_classmainprop.pk_org") != null) {
                     if(((Cell)var56.getValues().get("pk_classmainprop.pk_org")).getValue() == null) {
                        var60.setValue(((Cell)var56.getValues().get("pk_classmainprop.pk_org")).getValue());
                        var60.setDisplay((String)var47.get("GLOBLE00000000000000"));
                     } else {
                        var60.setValue(((Cell)var56.getValues().get("pk_classmainprop.pk_org")).getValue());
                        var60.setDisplay((String)var47.get(((Cell)var56.getValues().get("pk_classmainprop.pk_org")).getValue()));
                     }
                  }

                  var56.getValues().put("pk_classmainprop.pk_org", var60);
                  Cell var61 = new Cell();
                  if(var56.getValues().get("defaultvalue") != null) {
                     Object var62 = ((Cell)var56.getValues().get("defaultvalue")).getValue();
                     var61.setValue(var62);
                     String desfactor1 = (String)desdoctype.get(var62);
                     if(desfactor1 == null) {
                        desfactor1 = (String)var62;
                     }

                     var61.setDisplay(desfactor1);
                  }

                  var56.getValues().put("defaultvalue", var61);
                  if(var56.getValues().get("desfactor1") != null) {
                     Cell var63 = new Cell();
                     Object var64 = ((Cell)var56.getValues().get("desfactor1")).getValue();
                     var63.setValue(var64);
                     AccbookVO accbookVO = (AccbookVO)var53.get((String)var64);
                     if(accbookVO != null) {
                        if(currLangIndex == true) {
                           var63.setDisplay(accbookVO.getName());
                        } else {
                           var63.setDisplay((String)accbookVO.getAttributeValue((String)currLangIndex));
                        }
                     }

                     var56.getValues().put("desfactor1", var63);
                  }
               }
            }

            ArrayList var55 = new ArrayList();
            var55.add(var43);
            var55.add(grid2);
            return var55;
         }
      } catch (Exception var41) {
         ExceptionUtils.wrapException(var41);
         return null;
      }
   }
}
