package nccloud.web.fip.classdef.action;

import java.util.ArrayList;
import java.util.Map;
import nc.bs.logging.Logger;
import nc.itf.fip.impacfactor.IImpacFactorService;
import nc.vo.fip.impacfactor.ImpacFactorVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.classdef.action.FactorJsonVO;

public class ClassdefFacotrAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      Map map = (Map)json.fromJson(str, Map.class);
      String pk_system = (String)map.get("pk_system");
      String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
      IImpacFactorService ip = (IImpacFactorService)ServiceLocator.find(IImpacFactorService.class);

      try {
         ImpacFactorVO e = new ImpacFactorVO();
         e.setPk_group(pk_group);
         e.setPk_systypecode(pk_system);
         ImpacFactorVO[] factors = ip.queryByVO(e);
         if(factors == null) {
            factors = new ImpacFactorVO[0];
         }

         ArrayList lists = new ArrayList();
         Object currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq().intValue();
         ImpacFactorVO[] var12 = factors;
         int var13 = factors.length;

         for(int var14 = 0; var14 < var13; ++var14) {
            ImpacFactorVO vo = var12[var14];
            FactorJsonVO factorJsonVO = new FactorJsonVO();
            factorJsonVO.setKey(vo.getPk_factor());
            if(vo != null) {
               if(currLangIndex == 1) {
                  factorJsonVO.setTitle(vo.getAttributeValue("displayname") == null?"":vo.getAttributeValue("displayname").toString());
               } else {
                  factorJsonVO.setTitle(vo.getAttributeValue((String)currLangIndex) == null?vo.getAttributeValue("displayname").toString():vo.getAttributeValue((String)currLangIndex).toString());
               }
            }

            factorJsonVO.setEntityid(vo.getEntityid());
            lists.add(factorJsonVO);
         }

         return lists;
      } catch (BusinessException var17) {
         Logger.error("", var17);
         return null;
      }
   }
}
