package nccloud.web.fip.classdef.action;

import java.util.Map;
import nc.itf.fip.opreatinglog.IFactoryQueryService;
import nc.vo.bd.pub.BDCacheQueryUtil;
import nc.vo.ml.MultiLangContext;
import nc.vo.org.FactoryVO;
import nc.vo.org.OrgVO;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.classdef.IWebModuleClassdefService;

public class AccountingbookbyorgAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();

      try {
         Map e = (Map)json.fromJson(str, Map.class);
         String pkorg = (String)e.get("org");
         String desBilltype = (String)e.get("desBilltype");
         if(desBilltype != null && !"".equals(desBilltype)) {
            String pk_org = "";
            String currLangIndex;
            if("C0".equals(desBilltype)) {
               Map orgvo = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).queryAccountingBookIDByFinanceOrgIDWithMainAccountBookweb(new String[]{pkorg});
               if(orgvo != null && orgvo.size() > 0) {
                  pk_org = (String)orgvo.get(pkorg);
               }
            } else {
               String orgvo1;
               if("NRESA03".equals(desBilltype)) {
                  orgvo1 = ((IWebModuleClassdefService)ServiceLocator.find(IWebModuleClassdefService.class)).queryLiabilityBookIDByLiaCenterIDWithMainLiabilityBook(pkorg);
                  pk_org = orgvo1;
               } else if("CM02".equals(desBilltype)) {
                  orgvo1 = SessionContext.getInstance().getClientInfo().getPk_group();
                  currLangIndex = "11 = 11  and ( enablestate = 2 ) ";
                  FactoryVO[] vos = ((IFactoryQueryService)ServiceLocator.find(IFactoryQueryService.class)).queryFactoryByCondition(pkorg);
                  if(vos != null && vos.length > 0) {
                     pk_org = vos[0].getPk_factory();
                  }
               }
            }

            if(pk_org != null && !"".equals(pk_org)) {
               Object[] orgvo2 = BDCacheQueryUtil.queryVOsByIDs(OrgVO.class, "pk_org", new String[]{pk_org}, (String[])null);
               currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq().intValue();
               if(currLangIndex == 1) {
                  ((OrgVO)orgvo2[0]).setAttributeValue("name", ((OrgVO)orgvo2[0]).getAttributeValue("name"));
               } else {
                  ((OrgVO)orgvo2[0]).setAttributeValue("name", ((OrgVO)orgvo2[0]).getAttributeValue(currLangIndex));
               }

               return orgvo2;
            }
         }
      } catch (BusinessException var11) {
         ExceptionUtils.wrapException(var11.getMessage(), var11);
      }

      return null;
   }
}
