package nccloud.web.fip.billmapping.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import nc.itf.fip.billmapping.IFipBillMappingService;
import nc.vo.fip.billmapping.BillMappingVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.pattern.GridConvertor;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billgrid.BillGrid;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class QueryBillmappingAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         BillMappingVO vo = new BillMappingVO();
         if(info.getOid() != null) {
            vo.setPk_billtype(info.getOid());
         }

         vo.setPk_group(pk_group);
         BillMappingVO[] billMappingvos = ((IFipBillMappingService)ServiceLocator.find(IFipBillMappingService.class)).queryBillMappingByVO(vo);
         if(billMappingvos != null && billMappingvos.length != 0) {
            GridConvertor convertor1 = MultiLangContext.getInstance().getCurrentLangSeq().intValue();
            BillMappingVO[] convertor2 = billMappingvos;
            int grid1 = billMappingvos.length;

            for(int vo2 = 0; vo2 < grid1; ++vo2) {
               BillMappingVO vos2 = convertor2[vo2];
               if(convertor1 == 1) {
                  vos2.setExplanation(vos2.getExplanation());
               } else {
                  if(vos2.getAttributeValue(convertor1) != null) {
                     vos2.setExplanation((String)vos2.getAttributeValue(convertor1));
                  }

                  if(vos2.getAttributeValue(convertor1) != null) {
                     vos2.setAttrname(vos2.getAttributeValue(convertor1).toString());
                  }
               }
            }

            convertor1 = new GridConvertor();
            GridConvertor var23 = new GridConvertor();
            Grid var24 = convertor1.toGrid("billmapping", billMappingvos);
            BillMappingVO var25 = new BillMappingVO();
            var25.setAttrcode(NCLangRes4VoTransl.getNCLangRes().getStrByID("10170202", "1101702020002"));
            BillMappingVO[] var26 = new BillMappingVO[]{var25};
            Grid grid2 = var23.toGrid("billmapping-tx", var26);
            HashSet set = new HashSet();
            Row[] rows = var24.getModel().getRows();
            if(rows != null && rows.length > 0) {
               Row[] bgrid = rows;
               int translator = rows.length;

               int grids;
               for(grids = 0; grids < translator; ++grids) {
                  Row row = bgrid[grids];
                  Cell row1 = (Cell)row.getValues().get("entity_attr");
                  if(row1 != null && row1.getValue() != null) {
                     set.add((String)row1.getValue());
                  }
               }

               Map var27 = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertBillItemData(set, pk_group, "TX01");
               Row[] var29 = rows;
               grids = rows.length;

               for(int var32 = 0; var32 < grids; ++var32) {
                  Row var33 = var29[var32];
                  Cell cell = (Cell)var33.getValues().get("entity_attr");
                  if(cell != null && cell.getValue() != null && var27.get(cell.getValue()) != null) {
                     cell.setDisplay((String)var27.get(cell.getValue()));
                  }
               }
            }

            BillGrid var28 = new BillGrid();
            var28.setHead(var24);
            var28.setBody(grid2);
            var28.setTempletid("1001Z3100000000075R2");
            var28.setPageid(info.getPageCode());
            Translator var30 = new Translator();
            var30.translate(var28);
            ArrayList var31 = new ArrayList();
            var31.add(var24);
            var31.add(grid2);
            return var31;
         } else {
            return null;
         }
      } catch (Exception var22) {
         ExceptionUtils.wrapException(var22);
         return null;
      }
   }
}
