package nccloud.web.fip.attconfig.action;

import nc.itf.fip.attconfig.IFipEntityAttConfig;
import nc.vo.fip.attconfig.EntityAttributeConfigVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.GridConvertProcessor;
import nccloud.framework.web.ui.pattern.grid.Grid;

public class QueryAttconfigAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         EntityAttributeConfigVO vo = new EntityAttributeConfigVO();
         if(info.getOid() != null) {
            vo.setPk_billtype(info.getOid());
         }

         EntityAttributeConfigVO[] vos = ((IFipEntityAttConfig)ServiceLocator.find(IFipEntityAttConfig.class)).queryByVO(vo);
         if(vos == null) {
            return null;
         } else {
            GridConvertProcessor processor = new GridConvertProcessor();
            Grid grid = processor.convert(info.getPageCode(), vos);
            Translator translator = new Translator();
            translator.translate(grid);
            return grid;
         }
      } catch (Exception var10) {
         ExceptionUtils.wrapException(var10);
         return null;
      }
   }
}
