package nccloud.web.fip.attconfig.action;

import nc.vo.fip.pub.ExtBillTypeVO;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.sm.funcreg.ModuleVO;
import nccloud.web.uapbd.commons.tree.TreeWapper;

public class AttconfigNodeWapper extends TreeWapper {

   public static final String SYSTEM_FLAG = "sys";
   public static final String BILLTYPE_FLAG = "bill";


   public AttconfigNodeWapper(ExtBillTypeVO[] objs) {
      super(objs);
   }

   protected String getId(ExtBillTypeVO t) {
      return t.getPrimaryKey();
   }

   protected String getName(ExtBillTypeVO t) {
      if(t.isSystem()) {
         ModuleVO billtype1 = (ModuleVO)t.getDataVO();
         return billtype1.getResid() == null?billtype1.getSystypename():NCLangRes4VoTransl.getNCLangRes().getString("funcode", billtype1.getSystypename(), billtype1.getResid());
      } else {
         BilltypeVO billtype = (BilltypeVO)t.getDataVO();
         billtype.getPk_billtypecode();
         return FipLangTool.getCurrLangValue(t, "billtypename");
      }
   }

   public String getCode(ExtBillTypeVO t) {
      if(t.isSystem()) {
         ModuleVO billtype1 = (ModuleVO)t.getDataVO();
         return billtype1.getModuleid();
      } else {
         BilltypeVO billtype = (BilltypeVO)t.getDataVO();
         return billtype.getPk_billtypecode();
      }
   }

   protected String getPid(ExtBillTypeVO t) {
      if(t.isSystem()) {
         return null;
      } else {
         BilltypeVO billtype = (BilltypeVO)t.getDataVO();
         return billtype.getIstransaction() != null && billtype.getIstransaction().booleanValue()?billtype.getParentbilltype():billtype.getSystemcode();
      }
   }

   protected String getInnercode(ExtBillTypeVO t) {
      return null;
   }
}
