package nccloud.web.fip.accbookdiffer.action;

import java.io.Serializable;
import java.util.HashMap;
import nc.vo.pubapp.pagination.PaginationQueryVO;
import nc.vo.pubapp.pattern.model.entity.bill.IBill;

public class PageQueryVO implements Serializable {

   public static final String RECORD_IN_PAGE = "recordInPage";
   private static final long serialVersionUID = 761548308850627487L;
   private transient IBill[] currentPageBills;
   private String[] pks;


   public PageQueryVO(String[] pks, IBill[] bills) {
      this.pks = pks;
      this.currentPageBills = bills;
   }

   public IBill[] getCurrentPageBills() {
      if(this.currentPageBills != null) {
         IBill[] billArr = new IBill[this.currentPageBills.length];
         System.arraycopy(this.currentPageBills, 0, billArr, 0, this.currentPageBills.length);
         return billArr;
      } else {
         return this.currentPageBills;
      }
   }

   public String[] getPks() {
      return this.pks != null && this.pks.length > 0?(String[])this.pks.clone():this.pks;
   }

   public PaginationQueryVO toPaginationQueryVO() {
      PaginationQueryVO vo = new PaginationQueryVO();
      HashMap billmap = new HashMap();
      IBill[] var3 = this.currentPageBills;
      int var4 = var3.length;

      for(int var5 = 0; var5 < var4; ++var5) {
         IBill bill = var3[var5];
         billmap.put(bill.getPrimaryKey(), bill);
      }

      vo.setAllpks(this.pks);
      vo.setBillmap(billmap);
      return vo;
   }
}
