package nccloud.web.fip.accbookdiffer.action;

import java.util.HashMap;
import nc.pubitf.fip.service.IFipAccbookDifferQueryService;
import nc.vo.fip.accbook.AccbookDifferDetailFormVO;
import nc.vo.fip.accbook.AccbookDifferDetailVO;
import nc.vo.fip.accbook.AccbookDifferQryVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.FormConvertProcessor;
import nccloud.framework.web.processor.template.GridConvertProcessor;
import nccloud.framework.web.ui.pattern.form.Form;
import nccloud.framework.web.ui.pattern.grid.Grid;

public class AccbookDifferDetailQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Form form = null;
      Grid grid = null;
      String str = request.read();
      IJson json = JsonFactory.create();
      AccbookDifferQryVO info = (AccbookDifferQryVO)json.fromJson(str, AccbookDifferQryVO.class);
      HashMap resultMap = new HashMap();

      try {
         AccbookDifferDetailVO[] e = ((IFipAccbookDifferQueryService)ServiceLocator.find(IFipAccbookDifferQueryService.class)).queryDetailInfo(info.getSrc_system()[0], info.getPk_org(), info.getSrc_relationids(), info.getFlag());
         if(e == null || e.length == 0) {
            return null;
         }

         GridConvertProcessor processor = new GridConvertProcessor();
         if(e != null) {
            grid = processor.convertByTempletid("1001Z3100000000067IA", info.getPagecode(), e);
            Translator processor_form = new Translator();
            processor_form.translate(grid);
         }

         FormConvertProcessor processor_form1 = new FormConvertProcessor();
         AccbookDifferDetailFormVO formvo = ((IFipAccbookDifferQueryService)ServiceLocator.find(IFipAccbookDifferQueryService.class)).queryDetailFormInfo(info.getPk_org());
         if(formvo != null) {
            form = processor_form1.toFormByTempletid("1001Z3100000000067IA", info.getPagecode(), formvo);
            Translator translator = new Translator();
            translator.translate(form);
         }

         resultMap.put("head", form);
         resultMap.put("details", grid);
      } catch (Exception var13) {
         ExceptionUtils.wrapException(var13);
      }

      return resultMap;
   }
}
