package dev.greencat.shimmer.util.render.animation;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import dev.greencat.shimmer.util.render.animation.AnimationEngine;
import dev.greencat.shimmer.util.render.animation.AnimationManager;
import java.util.LinkedList;
import java.util.Queue;

public class QueueAnimationEngine extends AnimationEngine {
  public Queue<PositionWrapper> animationQueue = new LinkedList<>();
  
  public QueueAnimationEngine() {}
  
  public QueueAnimationEngine(int x, int y) {
    super(x, y);
  }
  
  public boolean isWorking() {
    return AnimationManager.animations.containsKey(this);
  }
  
  public void QueueMoveTo(int x, int y, double second, int type) {
    if (!isWorking()) {
      moveTo(x, y, second, type);
    } else {
      this.animationQueue.offer(new PositionWrapper(x, y, second, type));
    } 
  }
  
  public void callback() {
    if (!isWorking() && !this.animationQueue.isEmpty()) {
      PositionWrapper positionWrapper = this.animationQueue.poll();
      moveTo(positionWrapper.x, positionWrapper.y, positionWrapper.speed, positionWrapper.type);
    } 
  }
}
