package dev.greencat.shimmer.util.render.animation;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

public class InverseProportionFunction {
  private final double k;
  
  private double offsetX = 0.0D;
  
  private double offsetY = 0.0D;
  
  public InverseProportionFunction(double k) {
    this.k = k;
  }
  
  public InverseProportionFunction(double x, double y) {
    this.k = x * y;
  }
  
  public void setOffsetX(double value) {
    this.offsetX = value;
  }
  
  public void setOffsetY(double value) {
    this.offsetY = value;
  }
  
  public double getY(double x) {
    if (x + this.offsetX != 0.0D)
      return this.k / (x + this.offsetX) + this.offsetY; 
    return 0.0D;
  }
  
  public double getX(double y) {
    if (y + this.offsetY != 0.0D)
      return this.k / (y + this.offsetY) + this.offsetX; 
    return 0.0D;
  }
  
  public String toString() {
    return "K: " + this.k + " OffsetX " + this.offsetX + " OffsetY " + this.offsetY;
  }
}
