package dev.greencat.shimmer.util.render.animation;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import dev.greencat.shimmer.util.render.animation.AnimationManager;
import dev.greencat.shimmer.util.render.animation.InverseProportionFunction;
import dev.greencat.shimmer.util.render.animation.LinearFunction;

public class AnimationEngine {
  public double xCoord;
  
  public double yCoord;
  
  public double targetX;
  
  public double targetY;
  
  public boolean isRunning = false;
  
  public int type;
  
  public long endTime = 0L;
  
  public long startTime = 0L;
  
  public LinearFunction xLinearFunction;
  
  public LinearFunction yLinearFunction;
  
  public InverseProportionFunction xInverseProportionFunction;
  
  public InverseProportionFunction yInverseProportionFunction;
  
  public static final int EASE_OUT = 1;
  
  public static final int EASE_IN = 2;
  
  public static final int LINEAR = 3;
  
  public AnimationEngine(int x, int y) {
    this.xCoord = x;
    this.yCoord = y;
    this.targetX = x;
    this.targetY = y;
  }
  
  public AnimationEngine() {
    this.xCoord = 0.0D;
    this.yCoord = 0.0D;
    this.targetX = 0.0D;
    this.targetY = 0.0D;
  }
  
  public void setPosition(int x, int y) {
    this.xCoord = x;
    this.yCoord = y;
    this.targetX = x;
    this.targetY = y;
  }
  
  public void register() {
    AnimationManager.add(this);
    this.isRunning = true;
  }
  
  public void moveTo(float x, float y, double second, int type) {
    if (this.targetX == x && this.targetY == y)
      return; 
    this.startTime = System.currentTimeMillis();
    this.endTime = (long)(System.currentTimeMillis() + 1000.0D * second);
    this.targetX = x;
    this.targetY = y;
    this.xLinearFunction = null;
    this.yLinearFunction = null;
    this.xInverseProportionFunction = null;
    this.yInverseProportionFunction = null;
    this.type = type;
    if (type == 3) {
      this.xLinearFunction = new LinearFunction(1.0D, this.xCoord, 100.0D, this.targetX);
      this.yLinearFunction = new LinearFunction(1.0D, this.yCoord, 100.0D, this.targetY);
    } 
    if (type == 1) {
      this.xInverseProportionFunction = new InverseProportionFunction(2500.0D);
      this.xInverseProportionFunction.setOffsetX(20.0D);
      this.yInverseProportionFunction = new InverseProportionFunction(2500.0D);
      this.yInverseProportionFunction.setOffsetX(20.0D);
      double XFunctionYPositionAt1 = this.xInverseProportionFunction.getY(1.0D);
      double XFunctionYPositionAt100 = this.xInverseProportionFunction.getY(100.0D);
      this.xLinearFunction = new LinearFunction(XFunctionYPositionAt1, this.xCoord, XFunctionYPositionAt100, this.targetX);
      double YFunctionYPositionAt1 = this.yInverseProportionFunction.getY(1.0D);
      double YFunctionYPositionAt100 = this.yInverseProportionFunction.getY(100.0D);
      this.yLinearFunction = new LinearFunction(YFunctionYPositionAt1, this.yCoord, YFunctionYPositionAt100, this.targetY);
    } 
    if (type == 2) {
      this.xInverseProportionFunction = new InverseProportionFunction(-2500.0D);
      this.xInverseProportionFunction.setOffsetX(-121.0D);
      this.yInverseProportionFunction = new InverseProportionFunction(-2500.0D);
      this.yInverseProportionFunction.setOffsetX(-121.0D);
      double XFunctionYPositionAt1 = this.xInverseProportionFunction.getY(1.0D);
      double XFunctionYPositionAt100 = this.xInverseProportionFunction.getY(100.0D);
      this.xLinearFunction = new LinearFunction(XFunctionYPositionAt1, this.xCoord, XFunctionYPositionAt100, this.targetX);
      double YFunctionYPositionAt1 = this.yInverseProportionFunction.getY(1.0D);
      double YFunctionYPositionAt100 = this.yInverseProportionFunction.getY(100.0D);
      this.yLinearFunction = new LinearFunction(YFunctionYPositionAt1, this.yCoord, YFunctionYPositionAt100, this.targetY);
    } 
    register();
  }
  
  public void RenderTick() {
    if (System.currentTimeMillis() > this.endTime) {
      destroy();
      this.xCoord = this.targetX;
      this.yCoord = this.targetY;
    } 
    if (this.xCoord != this.targetX)
      this.xCoord = getXPosition(); 
    if (this.yCoord != this.targetY)
      this.yCoord = getYPosition(); 
    if (getXPosition() > this.xCoord && this.xCoord > this.targetX)
      this.xCoord = this.targetX; 
    if (getYPosition() > this.yCoord && this.yCoord > this.targetY)
      this.yCoord = this.targetY; 
    if (getXPosition() < this.xCoord && this.xCoord < this.targetX)
      this.xCoord = this.targetX; 
    if (getYPosition() < this.yCoord && this.yCoord < this.targetY)
      this.yCoord = this.targetY; 
    if (this.xCoord == this.targetX && this.yCoord == this.targetY)
      destroy(); 
    callback();
  }
  
  public void callback() {}
  
  public void destroy() {
    AnimationManager.destroy(this);
    this.isRunning = false;
  }
  
  public double getXPosition() {
    long currentTime = System.currentTimeMillis() - this.startTime;
    long allTime = this.endTime - this.startTime;
    double progress = currentTime / allTime * 100.0D;
    if (this.type == 3) {
      double d = this.xLinearFunction.getY(progress);
      return d;
    } 
    if (progress == 0.0D)
      return this.xCoord; 
    if (progress >= 100.0D)
      return this.targetX; 
    double numberInInverseProportion = this.xInverseProportionFunction.getY(progress);
    double exactlyPosition = this.xLinearFunction.getY(numberInInverseProportion);
    return exactlyPosition;
  }
  
  public double getYPosition() {
    long currentTime = System.currentTimeMillis() - this.startTime;
    long allTime = this.endTime - this.startTime;
    double progress = currentTime / allTime * 100.0D;
    if (this.type == 3) {
      double d = this.yLinearFunction.getY(progress);
      return d;
    } 
    if (progress == 0.0D)
      return this.yCoord; 
    if (progress >= 100.0D)
      return this.targetY; 
    double numberInInverseProportion = this.yInverseProportionFunction.getY(progress);
    double exactlyPosition = this.yLinearFunction.getY(numberInInverseProportion);
    return exactlyPosition;
  }
}
