package dev.greencat.shimmer.util.render;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.awt.Color;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class TextRenderUtil {
  private static long colorIndex = 0L;
  
  private static long colorCounter = 0L;
  
  private static long colorDelay = 0L;
  
  public static final int backgroundColor = (new Color(0, 0, 0, 100)).getRGB();
  
  public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, boolean seeThrough, class_4597 consumerProvider) {
    renderText(context, text, pos, 1.0F, seeThrough, consumerProvider);
  }
  
  public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, float scale, boolean seeThrough, class_4597 consumerProvider) {
    renderText(context, text, pos, scale, 0.0F, seeThrough, consumerProvider);
  }
  
  public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, float scale, float yOffset, boolean seeThrough, class_4597 consumerProvider) {
    renderText(context, text.method_30937(), pos, scale, yOffset, seeThrough, consumerProvider);
  }
  
  public static void renderText(WorldRenderContext context, class_5481 text, class_243 pos, float scale, float yOffset, boolean throughWalls, class_4597 consumerProvider) {
    Matrix4f positionMatrix = new Matrix4f();
    class_4184 camera = context.camera();
    class_243 cameraPos = camera.method_19326();
    class_327 textRenderer = (class_310.method_1551()).field_1772;
    scale *= 0.025F;
    positionMatrix
      .translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215()))
      .rotate((Quaternionfc)camera.method_23767())
      .scale(scale, -scale, scale);
    float xOffset = -textRenderer.method_30880(text) / 2.0F;
    GlStateManager._depthFunc(throughWalls ? 519 : 515);
    textRenderer.method_22942(text, xOffset, yOffset, -1, false, positionMatrix, consumerProvider, class_327.class_6415.field_33994, 0, 15728880);
    GlStateManager._depthFunc(515);
  }
  
  public static void renderHUDText(class_332 context, int x, int y, class_2561... text) {
    int height = text.length * 10;
    int width = 0;
    for (class_2561 t : text) {
      int length = (class_310.method_1551()).field_1772.method_30880(t.method_30937());
      if (length > width)
        width = length; 
    } 
    context.method_25294(x - 3, y - 3, x + width + 3, y + height + 3, backgroundColor);
    for (int i = 0; i < text.length; i++)
      context.method_51439((class_310.method_1551()).field_1772, text[i], x, y + i * 10, Color.WHITE.getRGB(), false); 
  }
  
  public static void colorText(class_332 context, int x, int y, String text) {
    colorText(context, x, y, text, false);
  }
  
  public static void colorText(class_332 context, int x, int y, String text, boolean cleanIndex) {
    int currentShift = 0;
    for (int i = 1; i < text.length() + 1; i++) {
      boolean swap = ((int)((float)(colorIndex + colorCounter) / 3.0F / 30.0F) % 2 == 0);
      Color currentColor = Color.getHSBColor(0.925F, ((swap ? (30.0F - (float)(colorIndex + colorCounter) / 3.0F % 30.0F) : ((float)(colorIndex + colorCounter) / 3.0F % 30.0F)) + 35.0F) / 100.0F, 1.0F);
      String currentString = text.substring(i - 1, i);
      context.method_25303((class_310.method_1551()).field_1772, currentString, x + currentShift, y, currentColor.getRGB());
      currentShift += (class_310.method_1551()).field_1772.method_1727(currentString);
      colorIndex += 12L;
    } 
    if (cleanIndex)
      colorIndex = 0L; 
  }
  
  public static void cleanIndex() {
    colorIndex = 0L;
  }
  
  public static void onRenderHUD(class_332 context, class_9779 tickCounter) {
    if (System.currentTimeMillis() - colorDelay >= 5L) {
      colorDelay = System.currentTimeMillis();
      colorCounter++;
    } 
    colorIndex = 0L;
  }
}
