package dev.greencat.shimmer.util.render;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import dev.greencat.shimmer.util.render.ShimmerRenderPipelines;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.OptionalDouble;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_9851;

public class ShimmerRenderLayer {
  private static final Double2ObjectMap<class_1921.class_4687> LINES_LAYERS = (Double2ObjectMap<class_1921.class_4687>)new Double2ObjectOpenHashMap();
  
  private static final Double2ObjectMap<class_1921.class_4687> LINES_THROUGH_WALLS_LAYERS = (Double2ObjectMap<class_1921.class_4687>)new Double2ObjectOpenHashMap();
  
  private static final Object2ObjectMap<class_2960, class_1921.class_4687> TEXTURE_LAYERS = (Object2ObjectMap<class_2960, class_1921.class_4687>)new Object2ObjectOpenHashMap();
  
  private static final Object2ObjectMap<class_2960, class_1921.class_4687> TEXTURE_THROUGH_WALLS_LAYERS = (Object2ObjectMap<class_2960, class_1921.class_4687>)new Object2ObjectOpenHashMap();
  
  public static final class_1921.class_4687 FILLED = class_1921.method_24049("filled", 1536, false, true, class_10799.field_56837, class_1921.class_4688.method_23598()
      .method_23607(class_4668.field_22241)
      .method_23617(false));
  
  public static final class_1921.class_4687 FILLED_THROUGH_WALLS = class_1921.method_24049("filled_through_walls", 1536, false, true, ShimmerRenderPipelines.FILLED_THROUGH_WALLS, class_1921.class_4688.method_23598()
      .method_23607(class_4668.field_22241)
      .method_23617(false));
  
  private static final DoubleFunction<class_1921.class_4687> LINES;
  
  private static final DoubleFunction<class_1921.class_4687> LINES_THROUGH_WALLS;
  
  static {
    LINES = (lineWidth -> class_1921.method_24049("lines", 1536, false, false, class_10799.field_56833, class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(lineWidth))).method_23607(class_4668.field_22241).method_23617(false)));
    LINES_THROUGH_WALLS = (lineWidth -> class_1921.method_24049("lines_through_walls", 1536, false, false, ShimmerRenderPipelines.LINES_THROUGH_WALLS, class_1921.class_4688.method_23598().method_23609(new class_4668.class_4677(OptionalDouble.of(lineWidth))).method_23607(class_4668.field_22241).method_23617(false)));
  }
  
  public static final class_1921.class_4687 QUADS = class_1921.method_24049("quad", 1536, false, true, class_10799.field_56865, class_1921.class_4688.method_23598()
      .method_23607(class_4668.field_22241)
      .method_23617(false));
  
  public static final class_1921.class_4687 QUADS_THROUGH_WALLS = class_1921.method_24049("quad_through_walls", 1536, false, true, ShimmerRenderPipelines.QUADS_THROUGH_WALLS, class_1921.class_4688.method_23598()
      .method_23607(class_4668.field_22241)
      .method_23617(false));
  
  private static final Function<class_2960, class_1921.class_4687> TEXTURE;
  
  private static final Function<class_2960, class_1921.class_4687> TEXTURE_THROUGH_WALLS;
  
  static {
    TEXTURE = (texture -> class_1921.method_24049("texture", 1536, false, true, ShimmerRenderPipelines.TEXTURE, class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(texture, class_9851.field_52395, false)).method_23607(class_4668.field_22241).method_23617(false)));
    TEXTURE_THROUGH_WALLS = (texture -> class_1921.method_24049("texture_through_walls", 1536, false, true, ShimmerRenderPipelines.TEXTURE_THROUGH_WALLS, class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(texture, class_9851.field_52395, false)).method_23607(class_4668.field_22241).method_23617(false)));
  }
  
  public static final class_1921.class_4687 CYLINDER = class_1921.method_24049("cylinder", 1536, false, true, ShimmerRenderPipelines.CYLINDER, class_1921.class_4688.method_23598()
      .method_23607(class_4668.field_22241)
      .method_23617(false));
  
  public static class_1921.class_4687 getLines(double lineWidth) {
    return (class_1921.class_4687)LINES_LAYERS.computeIfAbsent(lineWidth, LINES);
  }
  
  public static class_1921.class_4687 getLinesThroughWalls(double lineWidth) {
    return (class_1921.class_4687)LINES_THROUGH_WALLS_LAYERS.computeIfAbsent(lineWidth, LINES_THROUGH_WALLS);
  }
  
  public static class_1921.class_4687 getTexture(class_2960 texture) {
    return (class_1921.class_4687)TEXTURE_LAYERS.computeIfAbsent(texture, TEXTURE);
  }
  
  public static class_1921.class_4687 getTextureThroughWalls(class_2960 texture) {
    return (class_1921.class_4687)TEXTURE_THROUGH_WALLS_LAYERS.computeIfAbsent(texture, TEXTURE_THROUGH_WALLS);
  }
}
