package dev.greencat.shimmer.util.render;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.greencat.shimmer.mixin.DrawContextAccessor;
import java.awt.Color;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public class Rect {
  public static void draw2DRoundedRect(float x, float y, float width, float height, float radius, float z, Color color, class_332 context) {
    draw2DRoundedRect(x, y, width, height, radius, z, color, context, new boolean[] { true, true, true, true });
  }
  
  public static void draw2DRoundedRect(float x, float y, float width, float height, float radius, float z, Color color, class_332 context, boolean... control) {
    class_4587 matrixStack = context.method_51448();
    Matrix4f matrix = matrixStack.method_23760().method_23761();
    float red = color.getRed() / 255.0F;
    float green = color.getGreen() / 255.0F;
    float blue = color.getBlue() / 255.0F;
    float alpha = color.getAlpha() / 255.0F;
    GlStateManager._enableBlend();
    drawRect(matrix, context, x + radius, y, x + width - radius, y + height, z, red, green, blue, alpha);
    drawRect(matrix, context, x, y + radius, x + radius, y + height - radius, z, red, green, blue, alpha);
    drawRect(matrix, context, x + width - radius, y + radius, x + width, y + height - radius, z, red, green, blue, alpha);
    if (control.length > 0 && control[0]) {
      drawArc(matrix, context, x + radius, y + radius, radius, 180, 270, z, red, green, blue, alpha);
    } else {
      drawRect(matrix, context, x, y, x + radius, y + radius, z, red, green, blue, alpha);
    } 
    if (control.length > 1 && control[1]) {
      drawArc(matrix, context, x + width - radius, y + radius, radius, 270, 360, z, red, green, blue, alpha);
    } else {
      drawRect(matrix, context, x + width - radius, y, x + width, y + radius, z, red, green, blue, alpha);
    } 
    if (control.length > 3 && control[3]) {
      drawArc(matrix, context, x + width - radius, y + height - radius, radius, 0, 90, z, red, green, blue, alpha);
    } else {
      drawRect(matrix, context, x + width - radius, y + height - radius, x + width, y + height, z, red, green, blue, alpha);
    } 
    if (control.length > 2 && control[2]) {
      drawArc(matrix, context, x + radius, y + height - radius, radius, 90, 180, z, red, green, blue, alpha);
    } else {
      drawRect(matrix, context, x, y + height - radius, x + radius, y + height, z, red, green, blue, alpha);
    } 
    drawArc(matrix, context, 0.0F, 0.0F, 0.0F, 0, 0, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F);
    drawRect(matrix, context, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F);
    GlStateManager._disableBlend();
  }
  
  public static void drawRect(Matrix4f matrix, class_332 context, float x1, float y1, float x2, float y2, float z, float r, float g, float b, float a) {
    class_4588 buffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_51784());
    buffer.method_22918(matrix, x1, y1, z).method_22915(r, g, b, a);
    buffer.method_22918(matrix, x1, y2, z).method_22915(r, g, b, a);
    buffer.method_22918(matrix, x2, y2, z).method_22915(r, g, b, a);
    buffer.method_22918(matrix, x2, y1, z).method_22915(r, g, b, a);
  }
  
  private static void drawArc(Matrix4f matrix, class_332 context, float x, float y, float radius, int startAngle, int endAngle, float z, float r, float g, float b, float a) {
    class_4588 arcBuffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_62278());
    arcBuffer.method_22918(matrix, x, y, z).method_22915(r, g, b, a);
    for (int i = startAngle; i <= endAngle; i += 5) {
      double angle = Math.toRadians(i);
      float px = (float)(x + Math.cos(angle) * radius);
      float py = (float)(y + Math.sin(angle) * radius);
      arcBuffer.method_22918(matrix, px, py, z).method_22915(r, g, b, a);
    } 
  }
  
  public static void drawOutlinedRoundedRect(float x, float y, float width, float height, float radius, float z, Color color, float thickness, class_332 context) {
    drawOutlinedRoundedRect(x, y, width, height, radius, z, color, thickness, context, new boolean[] { true, true, true, true });
  }
  
  public static void drawOutlinedRoundedRect(float x1, float y1, float width1, float height1, float radius1, float z, Color color, float thickness, class_332 context, boolean... control) {
    float i;
    for (i = 0.0F; i <= thickness; i += 0.1F) {
      float x = x1 + i;
      float y = y1 + i;
      float width = width1 - 2.0F * i;
      float height = height1 - 2.0F * i;
      float radius = radius1 - i;
      class_4587 matrixStack = context.method_51448();
      Matrix4f matrix = matrixStack.method_23760().method_23761();
      float red = color.getRed() / 255.0F;
      float green = color.getGreen() / 255.0F;
      float blue = color.getBlue() / 255.0F;
      float alpha = color.getAlpha() / 255.0F;
      GlStateManager._enableBlend();
      class_4588 lineBuffer = ((DrawContextAccessor)context).getVertexConsumer().getBuffer(class_1921.method_49043(1.0D));
      RenderSystem.lineWidth(1.0F);
      if (control.length > 0 && control[0]) {
        drawArcOutline(matrix, lineBuffer, x + radius, y + radius, radius, 180, 270, z, red, green, blue, alpha);
      } else {
        drawLine(matrix, lineBuffer, x, y, x + radius, y, z, red, green, blue, alpha);
        drawLine(matrix, lineBuffer, x, y, x, y + radius, z, red, green, blue, alpha);
      } 
      drawLine(matrix, lineBuffer, x + radius, y, x + width - radius, y, z, red, green, blue, alpha);
      if (control.length > 1 && control[1]) {
        drawArcOutline(matrix, lineBuffer, x + width - radius, y + radius, radius, 270, 360, z, red, green, blue, alpha);
      } else {
        drawLine(matrix, lineBuffer, x + width - radius, y, x + width, y, z, red, green, blue, alpha);
        drawLine(matrix, lineBuffer, x + width, y, x + width, y + radius, z, red, green, blue, alpha);
      } 
      drawLine(matrix, lineBuffer, x + width, y + radius, x + width, y + height - radius, z, red, green, blue, alpha);
      if (control.length > 3 && control[3]) {
        drawArcOutline(matrix, lineBuffer, x + width - radius, y + height - radius, radius, 0, 90, z, red, green, blue, alpha);
      } else {
        drawLine(matrix, lineBuffer, x + width - radius, y + height, x + width, y + height, z, red, green, blue, alpha);
        drawLine(matrix, lineBuffer, x + width, y + height - radius, x + width, y + height, z, red, green, blue, alpha);
      } 
      drawLine(matrix, lineBuffer, x + radius, y + height, x + width - radius, y + height, z, red, green, blue, alpha);
      if (control.length > 2 && control[2]) {
        drawArcOutline(matrix, lineBuffer, x + radius, y + height - radius, radius, 90, 180, z, red, green, blue, alpha);
      } else {
        drawLine(matrix, lineBuffer, x, y + height, x + radius, y + height, z, red, green, blue, alpha);
        drawLine(matrix, lineBuffer, x, y + height - radius, x, y + height, z, red, green, blue, alpha);
      } 
      drawLine(matrix, lineBuffer, x, y + radius, x, y + height - radius, z, red, green, blue, alpha);
      GlStateManager._disableBlend();
    } 
  }
  
  private static void drawLine(Matrix4f matrix, class_4588 buffer, float x1, float y1, float x2, float y2, float z, float r, float g, float b, float a) {
    buffer.method_22918(matrix, x1, y1, z).method_22915(r, g, b, a);
    buffer.method_22918(matrix, x2, y2, z).method_22915(r, g, b, a);
  }
  
  private static void drawArcOutline(Matrix4f matrix, class_4588 buffer, float x, float y, float radius, int startAngle, int endAngle, float z, float r, float g, float b, float a) {
    float lastX = (float)(x + Math.cos(Math.toRadians(startAngle)) * radius);
    float lastY = (float)(y + Math.sin(Math.toRadians(startAngle)) * radius);
    for (int i = startAngle + 5; i <= endAngle; i += 5) {
      double angle = Math.toRadians(i);
      float currentX = (float)(x + Math.cos(angle) * radius);
      float currentY = (float)(y + Math.sin(angle) * radius);
      drawLine(matrix, buffer, lastX, lastY, currentX, currentY, z, r, g, b, a);
      lastX = currentX;
      lastY = currentY;
    } 
  }
}
