package dev.greencat.shimmer.util.render;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import com.mojang.blaze3d.opengl.GlStateManager;
import dev.greencat.shimmer.module.modules.render.OneGui;
import dev.greencat.shimmer.util.render.RenderUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class BackgroundEffect {
  public static final List<Point> pointList = new ArrayList<>();
  
  private static final Random random = new Random();
  
  public static boolean renderBackground = false;
  
  public static void onRender(class_332 context, int mouseX, int mouseY, float delta) {
    if ((class_310.method_1551()).field_1755 != null && (class_310.method_1551()).field_1755.getClass().getSimpleName().equals("MaterialGui"))
      return; 
    if (!OneGui.backgroundEffect.isEnabled())
      return; 
    if (class_310.method_1551() == null)
      return; 
    if (class_310.method_1551().method_22683() == null)
      return; 
    if (context.method_51448() == null)
      return; 
    if (renderBackground) {
      context.method_25296(0, 0, class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502(), -1072689136, -804253680);
      renderBackground = false;
    } 
    GlStateManager._disableDepthTest();
    if ((class_310.method_1551()).field_1687 == null)
      context.method_51433((class_310.method_1551()).field_1772, "", 0, 0, Color.white.getRGB(), true); 
    int scaledWidth = class_310.method_1551().method_22683().method_4486();
    int scaledHeight = class_310.method_1551().method_22683().method_4502();
    int size = (int)(scaledWidth / 50.0F * scaledHeight / 50.0F);
    if (pointList.size() < size)
      addPoint(); 
    List<Point> removalList = new ArrayList<>();
    for (Point point : pointList) {
      float vectorX = mouseX - point.x;
      float vectorY = mouseY - point.y;
      float distance = (float)Math.sqrt((vectorX * vectorX + vectorY * vectorY));
      float targetDistance = Math.min(scaledWidth / 7.0F, scaledHeight / 4.0F);
      if (distance <= targetDistance)
        RenderUtil.draw2DLine(context.method_51448(), mouseX, mouseY, point.x, point.y, ((class_310.method_1551()).field_1687 == null && !((class_310.method_1551()).field_1755 instanceof net.minecraft.class_442)) ? 0.0F : -0.0025F, Color.WHITE, 2.5F, context); 
      RenderUtil.draw2DCircle(context.method_51448(), point.x, point.y, ((class_310.method_1551()).field_1687 == null && !((class_310.method_1551()).field_1755 instanceof net.minecraft.class_442)) ? 0.0F : -0.0025F, 1.0F, Color.WHITE, context);
      point.update();
      if (point.x < -10.0F || point.y < -10.0F || point.x > (scaledWidth + 10) || point.y > (scaledHeight + 10))
        removalList.add(point); 
    } 
    pointList.removeAll(removalList);
    GlStateManager._enableBlend();
  }
  
  public static void addPoint() {
    int scaledWidth = class_310.method_1551().method_22683().method_4486();
    int scaledHeight = class_310.method_1551().method_22683().method_4502();
    pointList.add(new Point((random.nextBoolean() ? false : scaledWidth), (random.nextBoolean() ? false : scaledHeight), random.nextFloat() - 0.5F, random.nextFloat() - 0.5F));
  }
}
