package dev.greencat.shimmer.util.player.rotation;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.mixin.PlayerMoveC2SPacketAccessor;
import dev.greencat.shimmer.util.player.rotation.SmoothRotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_2886;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class ServerRotation {
  public static boolean useServerRotation = false;
  
  public static float serverYaw = 0.0F;
  
  private static final List<String> serverRotationModuleList = new ArrayList<>();
  
  public static float serverPitch = 0.0F;
  
  public static void registerServerRotationModule(String name) {
    serverRotationModuleList.add(name);
  }
  
  public static boolean onPacketSent(class_2596<?> packet) {
    check();
    if (packet instanceof class_2828) {
      class_2828 newPacket = (class_2828)packet;
      if (useServerRotation) {
        class_2828.class_2831 class_2831;
        PlayerMoveC2SPacketAccessor oldPacket = (PlayerMoveC2SPacketAccessor)packet;
        if (packet instanceof class_2828.class_2830)
          class_2828.class_2830 class_2830 = new class_2828.class_2830(oldPacket.getX(), oldPacket.getY(), oldPacket.getZ(), serverYaw, serverPitch, oldPacket.isOnGround(), oldPacket.horizontalCollision()); 
        if (packet instanceof class_2828.class_2831)
          class_2831 = new class_2828.class_2831(serverYaw, serverPitch, oldPacket.isOnGround(), oldPacket.horizontalCollision()); 
        ((class_634)Objects.<class_634>requireNonNull(class_310.method_1551().method_1562())).method_48296().method_10752((class_2596)class_2831, null);
        return false;
      } 
    } 
    if (packet instanceof class_2886) {
      class_2886 oldPacket = (class_2886)packet;
      if (useServerRotation) {
        ((class_634)Objects.<class_634>requireNonNull(class_310.method_1551().method_1562())).method_48296().method_10752((class_2596)new class_2886(oldPacket.method_12551(), oldPacket.method_42081(), serverYaw, serverPitch), null);
        return false;
      } 
    } 
    return true;
  }
  
  private static void check() {
    boolean hasServerRotationModuleEnabled = false;
    for (String modules : serverRotationModuleList) {
      if (Shimmer.getInstance().getModuleManager().isModuleEnabled(modules)) {
        hasServerRotationModuleEnabled = true;
        break;
      } 
    } 
    if ((SmoothRotation.running && !SmoothRotation.isServerRotation) || !hasServerRotationModuleEnabled)
      useServerRotation = false; 
  }
}
