package dev.greencat.shimmer.util.player;

package .tmp;

import baritone.api.BaritoneAPI;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalBlock;
import dev.greencat.shimmer.util.player.rotation.Rotation;
import dev.greencat.shimmer.util.player.rotation.SmoothRotation;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class WalkerUtils {
  private static boolean isConfigLoaded = false;
  
  public static boolean walkTo(class_2338 pos) {
    if (isActive())
      cancel(); 
    if ((class_310.method_1551()).field_1724 == null)
      return false; 
    (BaritoneAPI.getSettings()).allowSprint.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).considerPotionEffects.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).avoidance.value = Boolean.valueOf(false);
    (BaritoneAPI.getSettings()).allowWalkOnBottomSlab.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).antiCheatCompatibility.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).allowParkour.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).allowBreak.value = Boolean.valueOf(false);
    (BaritoneAPI.getSettings()).allowParkourAscend.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).renderGoal.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).allowPlace.value = Boolean.valueOf(false);
    (BaritoneAPI.getSettings()).renderPath.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).assumeSafeWalk.value = Boolean.valueOf(false);
    if (!isConfigLoaded) {
      (class_310.method_1551()).field_1724.field_3944.method_45729("#blocksToAvoid oak_fence_gate");
      isConfigLoaded = true;
    } 
    BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().setGoalAndPath((Goal)new GoalBlock(pos.method_10263(), pos.method_10264() + 1, pos.method_10260()));
    double motionX = (class_310.method_1551()).field_1724.method_60478().method_10216();
    double motionZ = (class_310.method_1551()).field_1724.method_60478().method_10215();
    double playerYawX = Math.cos((class_3532.method_15393((class_310.method_1551()).field_1724.method_36454()) / 180.0F) * Math.PI);
    double playerYawY = Math.sin((class_3532.method_15393((class_310.method_1551()).field_1724.method_36454()) / 180.0F) * Math.PI);
    double degree = (motionX * motionZ == 0.0D || playerYawX * playerYawY == 0.0D) ? -10000.0D : (Math.acos((motionX * playerYawX + motionZ * playerYawY) / Math.sqrt(motionX * motionX + motionZ * motionZ)) * 180.0D / Math.PI);
    float yaw = (float)((degree == -10000.0D || Double.isNaN(degree)) ? (class_310.method_1551()).field_1724.method_36454() : ((class_310.method_1551()).field_1724.method_36454() + degree / 2.0D - 45.0D));
    SmoothRotation.smoothLook(new Rotation(yaw, (class_310.method_1551()).field_1724.method_36455()), 100, () -> {
        
        });
    return true;
  }
  
  public static boolean walkToBaritoneRotation(class_2338 pos) {
    if (isActive())
      cancel(); 
    if ((class_310.method_1551()).field_1724 == null)
      return false; 
    (BaritoneAPI.getSettings()).allowSprint.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).considerPotionEffects.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).avoidance.value = Boolean.valueOf(false);
    (BaritoneAPI.getSettings()).allowWalkOnBottomSlab.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).antiCheatCompatibility.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).allowParkour.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).allowBreak.value = Boolean.valueOf(false);
    (BaritoneAPI.getSettings()).allowParkourAscend.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).renderGoal.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).allowPlace.value = Boolean.valueOf(false);
    (BaritoneAPI.getSettings()).renderPath.value = Boolean.valueOf(true);
    (BaritoneAPI.getSettings()).assumeSafeWalk.value = Boolean.valueOf(false);
    (BaritoneAPI.getSettings()).smoothLook.value = Boolean.valueOf(true);
    BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().setGoalAndPath((Goal)new GoalBlock(pos.method_10263(), pos.method_10264() + 1, pos.method_10260()));
    if (!isConfigLoaded) {
      (class_310.method_1551()).field_1724.field_3944.method_45729("#blocksToAvoid oak_fence_gate");
      isConfigLoaded = true;
    } 
    return true;
  }
  
  public static boolean isActive() {
    return BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().isActive();
  }
  
  public static void cancel() {
    BaritoneAPI.getProvider().getPrimaryBaritone().getPathingBehavior().cancelEverything();
  }
  
  public static void handleRotation(class_310 mc) {
    if (mc.field_1724 != null && isActive()) {
      double motionX = mc.field_1724.method_60478().method_10216();
      double motionZ = mc.field_1724.method_60478().method_10215();
      double playerYawX = Math.cos((class_3532.method_15393(mc.field_1724.method_36454()) / 180.0F) * Math.PI);
      double playerYawY = Math.sin((class_3532.method_15393(mc.field_1724.method_36454()) / 180.0F) * Math.PI);
      double degree = (motionX * motionZ == 0.0D || playerYawX * playerYawY == 0.0D) ? -10000.0D : (Math.acos((motionX * playerYawX + motionZ * playerYawY) / Math.sqrt(motionX * motionX + motionZ * motionZ)) * 180.0D / Math.PI);
      float yaw = (float)((degree == -10000.0D || Double.isNaN(degree)) ? mc.field_1724.method_36454() : (mc.field_1724.method_36454() + degree / 2.0D - 45.0D));
      if (Math.abs(mc.field_1724.method_36454() - yaw) >= (new Random()).nextDouble(3.0D, 8.0D))
        SmoothRotation.smoothLook(new Rotation(yaw, mc.field_1724.method_36455()), 300, () -> {
            
            }); 
    } 
  }
}
