package dev.greencat.shimmer.util.irc;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.module.modules.misc.AuctionTracker;
import dev.greencat.shimmer.util.AuctionItem;
import dev.greencat.shimmer.util.HaikuLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_310;

public class IRC extends Thread {
  public Socket socket;
  
  public BufferedReader reader;
  
  public PrintWriter writer;
  
  public boolean closed = false;
  
  public IRC() throws IOException {
    try {
      this.socket = new Socket("xg-2.frp.one", 12783);
      this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8));
      this.writer = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8));
      HaikuLogger.info("[IRC] IRC已链接,输入!disconnect断开链接,!{消息}发送消息");
    } catch (IOException e) {
      try {
        this.socket.close();
        this.reader.close();
        this.writer.close();
        e.printStackTrace();
      } catch (Exception exception) {}
    } 
  }
  
  public void run() {
    String message = "";
    if (this.socket == null)
      return; 
    while (true) {
      try {
        if ((message = this.reader.readLine()) == null)
          break; 
      } catch (IOException e) {
        try {
          if (!this.closed) {
            if (!(Shimmer.getInstance()).IRC.socket.isClosed())
              (Shimmer.getInstance()).IRC.socket.shutdownInput(); 
            if (!(Shimmer.getInstance()).IRC.socket.isClosed())
              (Shimmer.getInstance()).IRC.socket.shutdownOutput(); 
            if (!this.socket.isClosed())
              this.socket.close(); 
            HaikuLogger.info("[IRC] IRC已断开链接,输入!reconnect重新链接");
            (Shimmer.getInstance()).IRC = null;
          } 
        } catch (Exception ex) {
          ex.printStackTrace();
        } 
        break;
      } 
      received(message);
    } 
  }
  
  public void received(String message) {
    if (message.equals("#requestUsername"))
      write("#Username " + class_310.method_1551().method_1548().method_1676()); 
    if (message.equals("#noVerify"))
      HaikuLogger.info("[IRC] You was kicked from IRC channel because of verify too late"); 
    if (message.equals("#CatGirl"))
      write("#CatGirl"); 
    if (message.startsWith("#newPlayerJoin")) {
      String username = message.split("\\|")[1];
      HaikuLogger.ircJoin(username);
    } 
    if (message.startsWith("#playerLeave")) {
      String username = message.split("\\|")[1];
      HaikuLogger.ircLeave(username);
    } 
    if (message.startsWith("#playerList")) {
      String[] username = message.split("\\|");
      HaikuLogger.ircChatSplitter();
      HaikuLogger.ircOnlinePlayerNumber(username.length - 1);
      HaikuLogger.ircChatSplitter();
      StringBuilder sb = new StringBuilder();
      for (int i = 0; i < username.length; i++) {
        if (i != 0)
          if (i % 3 == 0) {
            sb.append(username[i] + " ");
            HaikuLogger.ircSystemMessage(sb.toString());
            sb = new StringBuilder();
          } else {
            sb.append(username[i] + " ");
          }  
      } 
      if ((username.length - 1) % 3 != 0)
        HaikuLogger.ircSystemMessage(sb.toString()); 
      HaikuLogger.ircChatSplitter();
    } 
    if (message.startsWith("#Auction") && 
      Shimmer.getInstance().getModuleManager().isModuleEnabled("AuctionTracker")) {
      String[] itemInfo = message.split("\\|");
      AuctionItem item = new AuctionItem(itemInfo[1], itemInfo[2], Long.parseLong(itemInfo[3]), itemInfo[4]);
      AuctionTracker.cowList.add(item);
    } 
    if (message.startsWith("#ChatMessage")) {
      String username = message.split("\\|")[1];
      String chatMessage = message.split("\\|")[2];
      HaikuLogger.irc(username, chatMessage);
    } 
  }
  
  public void write(String message) {
    this.writer.println(message);
    this.writer.flush();
  }
}
