package dev.greencat.shimmer.util;

package .tmp;

import dev.greencat.shimmer.module.modules.misc.Cat;
import dev.greencat.shimmer.module.modules.misc.Translator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class RankingOverrider {
  private static Properties ranking = new Properties();
  
  public RankingOverrider() {
    InputStream rankingStream = Translator.class.getResourceAsStream("/assets/shimmer/ranking.properties");
    try {
      ranking.load(new InputStreamReader(rankingStream, StandardCharsets.UTF_8));
    } catch (Exception e) {
      e.printStackTrace();
    } 
  }
  
  public static String override(String text) {
    String newLevel = ranking.getProperty(text);
    if (Cat.rankingOverrideOriginal.isEnabled())
      newLevel = newLevel + "(" + newLevel + ")"; 
    if (newLevel == null)
      return text; 
    return newLevel;
  }
}
