package dev.greencat.shimmer.module.modules.render;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.util.render.RenderUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1481;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

public class TurtleESP extends Module {
  private static final HashMap<String, Color> colorMap = new HashMap<>();
  
  public TurtleESP() {
    super("TurtleESP", "Allow you see Turtle Mob through the wall", -1, Module.Category.RENDER);
  }
  
  public void onEnable() {
    colorMap.put(class_1481.class.getSimpleName(), new Color(15, 255, 220, 160));
    super.onEnable();
  }
  
  public void onDisable() {
    super.onDisable();
    colorMap.clear();
  }
  
  private static Color getColor(class_1297 entity) {
    if (entity instanceof net.minecraft.class_1657) {
      if (entity.method_5476().method_10866().method_10973() != null)
        return new Color(entity.method_5476().method_10866().method_10973().method_27716()); 
      return colorMap.get(entity.getClass().getSimpleName());
    } 
    return colorMap.get(entity.getClass().getSimpleName());
  }
  
  @ShimmerSubscribe
  public void onRender(RenderEvent.Post event) {
    if (mc.field_1687 == null || mc.field_1724 == null)
      return; 
    for (class_1297 entity : mc.field_1687.method_18112()) {
      if (entity instanceof class_1481) {
        class_4184 camera = mc.field_1773.method_19418();
        class_243 start = (new class_243(0.0D, 0.0D, 1.0D)).method_1037(-((float)Math.toRadians(camera.method_19329()))).method_1024(-((float)Math.toRadians(camera.method_19330())));
        class_243 end = RenderUtil.smoothen(entity, event.wrc.tickCounter().method_60637(false)).method_1031(0.0D, entity.method_5751(), 0.0D);
        RenderUtil.draw3DLineFromPlayer(Objects.<class_4587>requireNonNull(event.wrc.matrixStack()), start, end, getColor(entity), event.wrc);
        RenderUtil.draw2DOutline(entity, getColor(entity), event.wrc.matrixStack(), event.wrc);
      } 
    } 
  }
}
