package dev.greencat.shimmer.module.modules.render;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import com.mojang.blaze3d.opengl.GlStateManager;
import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.RenderInGameHudEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.modules.misc.RainTimer;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.util.render.Rect;
import dev.greencat.shimmer.util.render.Shadow;
import dev.greencat.shimmer.util.render.TextRenderUtil;
import dev.greencat.shimmer.util.render.animation.AnimationEngine;
import dev.greencat.shimmer.util.world.TPSUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_5348;

public class Hud extends Module {
  public final BooleanSetting arraylist = new BooleanSetting("Arraylist", "Renders the Shimmer arraylist.", true);
  
  public final BooleanSetting ticks = new BooleanSetting("TPS", "Renders the ticks per second.", true);
  
  public final BooleanSetting fps = new BooleanSetting("FPS", "Renders the frames per second.", true);
  
  private final AnimationEngine rectAnimation = new AnimationEngine(0, 0);
  
  private long colorCounter = 0L;
  
  private long colorDelay = 0L;
  
  private final AnimationEngine normalInformationAnimation = new AnimationEngine(0, 0);
  
  private final int arrayListColor = (new Color(0, 0, 0, 120)).getRGB();
  
  private final Color centerHUDColor = new Color(0, 0, 0, 120);
  
  private static CopyOnWriteArrayList<class_2561> noticeList = new CopyOnWriteArrayList<>();
  
  private static long lastMesaage = 0L;
  
  private static int arrayListHeight = 0;
  
  public Hud() {
    super("HUD", "Renders the Shimmer hud.", -1, Module.Category.RENDER);
    addSettings(new Setting[] { (Setting)this.arraylist, (Setting)this.ticks, (Setting)this.fps });
  }
  
  public void onEnable() {
    super.onEnable();
  }
  
  public static void onMessage(class_2561... texts) {
    noticeList.clear();
    Collections.addAll(noticeList, texts);
    lastMesaage = System.currentTimeMillis();
  }
  
  public AnimationEngine getRectAnimation() {
    return this.rectAnimation;
  }
  
  public int getArrayListHeight() {
    return arrayListHeight;
  }
  
  @ShimmerSubscribe
  public void onRender(RenderInGameHudEvent event) {
    if (mc.field_1687 == null || mc.field_1724 == null)
      return; 
    if (mc.method_53526().method_53536())
      return; 
    if (!(Shimmer.getInstance()).isSorted) {
      (Shimmer.getInstance()).isSorted = true;
      Shimmer.getInstance().getModuleManager().refreshEnabled();
    } 
    int screenWidth = mc.method_22683().method_4486();
    String tpsInfo = "TPS: " + TPSUtil.INSTANCE.getTPS();
    String fpsInfo = mc.field_1770.split(" ")[0];
    String fpsString = "FPS:" + fpsInfo;
    int rectX = Math.max(screenWidth / 10, mc.field_1772.method_1727("Shimmer |") + (this.fps.isEnabled() ? (mc.field_1772.method_1727(fpsString) + 5) : 0) + (this.ticks.isEnabled() ? (mc.field_1772.method_1727(tpsInfo) + 5) : 0) + 20);
    int rectY = 14 + (Shimmer.getInstance().getModuleManager().getModule("RainTimer").isEnabled() ? 14 : 0);
    if (System.currentTimeMillis() - lastMesaage <= 1200L && !noticeList.isEmpty()) {
      int longest = 0;
      for (class_2561 text : noticeList) {
        int length = mc.field_1772.method_27525((class_5348)text);
        if (length > longest)
          longest = length; 
      } 
      rectX = longest + 20;
      rectY = noticeList.size() * 12 + 2;
      this.normalInformationAnimation.moveTo(0.0F, (-12 + (Shimmer.getInstance().getModuleManager().getModule("RainTimer").isEnabled() ? -14 : 0)), 0.3D, 1);
    } else if (!noticeList.isEmpty()) {
      noticeList.clear();
    } 
    if (this.rectAnimation.xCoord == 0.0D && this.rectAnimation.yCoord == 0.0D) {
      this.rectAnimation.xCoord = rectX;
      this.rectAnimation.yCoord = rectY;
    } 
    this.rectAnimation.moveTo(rectX, rectY, 0.3D, 1);
    event.getContext().method_51448().method_22903();
    GlStateManager._enableBlend();
    Rect.draw2DRoundedRect((float)((screenWidth / 2.0F) - this.rectAnimation.xCoord / 2.0D), 3.0F, (float)this.rectAnimation.xCoord, (float)this.rectAnimation.yCoord, (float)(this.rectAnimation.yCoord / 2.0D), 0.0F, this.centerHUDColor, event.getContext());
    event.getContext().method_51448().method_22909();
    if (System.currentTimeMillis() - lastMesaage > 1220L && System.currentTimeMillis() - lastMesaage < 1550L) {
      int longest = Math.max(Math.max(mc.field_1772.method_1727("Shimmer |"), mc.field_1772.method_1727(fpsString)), mc.field_1772.method_1727(tpsInfo)) + 20;
      this.rectAnimation.moveTo(longest, rectY, 0.3D, 1);
    } 
    if (System.currentTimeMillis() - lastMesaage > 1800L) {
      this.normalInformationAnimation.moveTo(0.0F, 6.0F, 0.3D, 1);
    } else if (!noticeList.isEmpty()) {
      int i = 0;
      for (class_2561 text : noticeList) {
        event.getContext().method_25303(mc.field_1772, text.getString(), screenWidth / 2 - mc.field_1772.method_27525((class_5348)text) / 2, 6 + i * 11, 16777215);
        i++;
      } 
      TextRenderUtil.cleanIndex();
    } 
    event.getContext().method_25303(mc.field_1772, "Shimmer |", (System.currentTimeMillis() - lastMesaage <= 1200L) ? (screenWidth / 2 - mc.field_1772.method_1727("Shimmer |") / 2) : (screenWidth / 2 - (int)this.rectAnimation.xCoord / 2 + 10), (int)this.normalInformationAnimation.yCoord, 16777215);
    if (this.fps.isEnabled())
      event.getContext().method_25303(mc.field_1772, fpsString, (System.currentTimeMillis() - lastMesaage <= 1200L) ? (screenWidth / 2 - mc.field_1772.method_1727("Shimmer |") / 2) : (screenWidth / 2 - (int)this.rectAnimation.xCoord / 2 + 15 + mc.field_1772.method_1727("Shimmer |")), (int)this.normalInformationAnimation.yCoord, 16777215); 
    if (this.ticks.isEnabled())
      event.getContext().method_25303(mc.field_1772, tpsInfo, (System.currentTimeMillis() - lastMesaage <= 1200L) ? (screenWidth / 2 - mc.field_1772.method_1727("Shimmer |") / 2) : (screenWidth / 2 - (int)this.rectAnimation.xCoord / 2 + 15 + mc.field_1772.method_1727("Shimmer |") + (this.fps.isEnabled() ? (mc.field_1772.method_1727(fpsString) + 5) : 0)), (int)this.normalInformationAnimation.yCoord, 16777215); 
    if (Shimmer.getInstance().getModuleManager().getModule("RainTimer").isEnabled()) {
      class_2561 rain = RainTimer.getStringForRenderAndUpdate();
      event.getContext().method_27535(mc.field_1772, rain, screenWidth / 2 - mc.field_1772.method_27525((class_5348)rain) / 2, (int)this.normalInformationAnimation.yCoord + 12, 16777215);
    } 
    if (System.currentTimeMillis() - this.colorDelay >= 30L) {
      this.colorDelay = System.currentTimeMillis();
      this.colorCounter++;
    } 
    int y = 2;
    int lastWidth = mc.field_1772.method_1727((Shimmer.getInstance().getModuleManager()).enabledModules.getFirst()) + 8;
    arrayListHeight = 0;
    if (this.arraylist.isEnabled())
      for (String str : (Shimmer.getInstance().getModuleManager()).enabledModules) {
        boolean swap = ((int)((float)(y + this.colorCounter) / 3.0F / 30.0F) % 2 == 0);
        Color currentColor = Color.getHSBColor(0.925F, ((swap ? (30.0F - (float)(y + this.colorCounter) / 3.0F % 30.0F) : ((float)(y + this.colorCounter) / 3.0F % 30.0F)) + 35.0F) / 100.0F, 1.0F);
        event.getContext().method_25294(screenWidth - mc.field_1772.method_1727(str) - 3 - 5, y - 2, screenWidth, y + 10, this.arrayListColor);
        event.getContext().method_25294(screenWidth - 3, y - 2, screenWidth, y + 10, currentColor.getRGB());
        int widthDiffer = lastWidth - mc.field_1772.method_1727(str) - 8;
        Shadow.drawShadow(screenWidth - mc.field_1772.method_1727(str) - 3 - 5 - widthDiffer, y - 14, widthDiffer, 12, event.getContext(), Shadow.ShadowLocation.BOTTOM);
        Shadow.drawShadow(screenWidth - mc.field_1772.method_1727(str) - 3 - 5, y - 2, 0, 12, event.getContext(), Shadow.ShadowLocation.LEFT);
        Shadow.drawShadow(screenWidth - mc.field_1772.method_1727(str) - 3 - 5, y - 2, 0, 12, event.getContext(), Shadow.ShadowLocation.BOTTOM_LEFT);
        event.getContext().method_25303(mc.field_1772, str, screenWidth - mc.field_1772.method_1727(str) - 5, y, currentColor.getRGB());
        lastWidth = mc.field_1772.method_1727(str) + 8;
        y += 12;
      }  
    arrayListHeight = y - 2;
    Shadow.drawShadow(screenWidth - lastWidth, y - 14, lastWidth, 12, event.getContext(), Shadow.ShadowLocation.BOTTOM);
  }
}
