package dev.greencat.shimmer.module.modules.render;

package .var.folders.cl.9twcgjfx4vsg5zl73c6wxmvm0000gn.T;

import dev.greencat.shimmer.event.events.ArmRenderEvent;
import dev.greencat.shimmer.event.events.HeldItemRendererEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public class Animation extends Module {
  public static final NumberSetting mainHandSwingProgress = new NumberSetting("Swing Progress(Main)", "Your main hand swing progress", 0.0D, 0.0D, 1.0D, 0.1D);
  
  public static final NumberSetting offHandSwingProgress = new NumberSetting("Swing Progress(Off)", "Your offhand swing progress", 0.0D, 0.0D, 1.0D, 0.1D);
  
  public static final BooleanSetting oldAnimation = new BooleanSetting("Old Animation", "Switch attack animation to 1.8.9 style", true);
  
  public static final BooleanSetting noFoodAnimation = new BooleanSetting("No Food Animation", "Disable food eating animation", false);
  
  public static final NumberSetting ArmRotateX = new NumberSetting("Arm Rotate X", "Your hand rotate on X axis", 0.0D, -180.0D, 180.0D, 0.1D);
  
  public static final NumberSetting ArmRotateY = new NumberSetting("Arm Rotate Y", "Your hand rotate on Y axis", 0.0D, -180.0D, 180.0D, 0.1D);
  
  public static final NumberSetting ArmRotateZ = new NumberSetting("Arm Rotate Z", "Your hand rotate on Z axis", 0.0D, -180.0D, 180.0D, 0.1D);
  
  public static final NumberSetting ArmScaleX = new NumberSetting("Arm Scale X", "Your hand scale on X axis", 1.0D, 0.0D, 5.0D, 0.1D);
  
  public static final NumberSetting ArmScaleY = new NumberSetting("Arm Scale Y", "Your hand scale on Y axis", 1.0D, 0.0D, 5.0D, 0.1D);
  
  public static final NumberSetting ArmScaleZ = new NumberSetting("Arm Scale Z", "Your hand scale on Z axis", 1.0D, 0.0D, 5.0D, 0.1D);
  
  public static final NumberSetting ArmTranslateX = new NumberSetting("Arm Translate X", "Your hand translate on X axis", 0.0D, -3.0D, 3.0D, 0.1D);
  
  public static final NumberSetting ArmTranslateY = new NumberSetting("Arm Translate Y", "Your hand translate on Y axis", 0.0D, -3.0D, 3.0D, 0.1D);
  
  public static final NumberSetting ArmTranslateZ = new NumberSetting("Arm Translate Z", "Your hand translate on Z axis", 0.0D, -3.0D, 3.0D, 0.1D);
  
  public static final NumberSetting ItemRotateX = new NumberSetting("Item Rotate X", "Your item rotate on X axis", 0.0D, -180.0D, 180.0D, 0.1D);
  
  public static final NumberSetting ItemRotateY = new NumberSetting("Item Rotate Y", "Your item rotate on Y axis", 0.0D, -180.0D, 180.0D, 0.1D);
  
  public static final NumberSetting ItemRotateZ = new NumberSetting("Item Rotate Z", "Your item rotate on Z axis", 0.0D, -180.0D, 180.0D, 0.1D);
  
  public static final NumberSetting ItemScaleX = new NumberSetting("Item Scale X", "Your item scale on X axis", 1.0D, 0.0D, 5.0D, 0.1D);
  
  public static final NumberSetting ItemScaleY = new NumberSetting("Item Scale Y", "Your item scale on Y axis", 1.0D, 0.0D, 5.0D, 0.1D);
  
  public static final NumberSetting ItemScaleZ = new NumberSetting("Item Scale Z", "Your item scale on Z axis", 1.0D, 0.0D, 5.0D, 0.1D);
  
  public static final NumberSetting ItemTranslateX = new NumberSetting("Item Translate X", "Your item translate on X axis", 0.0D, -3.0D, 3.0D, 0.1D);
  
  public static final NumberSetting ItemTranslateY = new NumberSetting("Item Translate Y", "Your item translate on Y axis", 0.0D, -3.0D, 3.0D, 0.1D);
  
  public static final NumberSetting ItemTranslateZ = new NumberSetting("Item Translate Z", "Your item translate on Z axis", 0.0D, -3.0D, 3.0D, 0.1D);
  
  public static final NumberSetting swingSpeed = new NumberSetting("Swing Speed", "Your swing speed", 6.0D, 0.0D, 50.0D, 0.1D);
  
  public Animation() {
    super("Animation", "Allow you change your animation", -1, Module.Category.RENDER);
    addSettings(new Setting[] { 
          (Setting)swingSpeed, (Setting)mainHandSwingProgress, (Setting)offHandSwingProgress, (Setting)oldAnimation, (Setting)noFoodAnimation, (Setting)ArmRotateX, (Setting)ArmRotateY, (Setting)ArmRotateZ, (Setting)ArmScaleX, (Setting)ArmScaleY, 
          (Setting)ArmScaleZ, (Setting)ArmTranslateX, (Setting)ArmTranslateY, (Setting)ArmTranslateZ, (Setting)ItemRotateX, (Setting)ItemRotateY, (Setting)ItemRotateZ, (Setting)ItemScaleX, (Setting)ItemScaleY, (Setting)ItemScaleZ, 
          (Setting)ItemTranslateX, (Setting)ItemTranslateY, (Setting)ItemTranslateZ });
  }
  
  @ShimmerSubscribe
  public void onRenderArm(ArmRenderEvent event) {
    rotate(event.matrices, new Vector3d(ArmRotateX.getValue(), ArmRotateY.getValue(), ArmRotateZ.getValue()));
    scale(event.matrices, new Vector3d(ArmScaleX.getValue(), ArmScaleY.getValue(), ArmScaleZ.getValue()));
    translate(event.matrices, new Vector3d(ArmTranslateX.getValue(), ArmTranslateY.getValue(), ArmTranslateZ.getValue()));
  }
  
  @ShimmerSubscribe
  public void onRenderItem(HeldItemRendererEvent event) {
    rotate(event.matrices, new Vector3d(ItemRotateX.getValue(), ItemRotateY.getValue(), ItemRotateZ.getValue()));
    scale(event.matrices, new Vector3d(ItemScaleX.getValue(), ItemScaleY.getValue(), ItemScaleZ.getValue()));
    translate(event.matrices, new Vector3d(ItemTranslateX.getValue(), ItemTranslateY.getValue(), ItemTranslateZ.getValue()));
  }
  
  private void rotate(class_4587 matrix, Vector3d rotation) {
    matrix.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees((float)rotation.x));
    matrix.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)rotation.y));
    matrix.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees((float)rotation.z));
  }
  
  private void scale(class_4587 matrix, Vector3d scale) {
    matrix.method_22905((float)scale.x, (float)scale.y, (float)scale.z);
  }
  
  private void translate(class_4587 matrix, Vector3d translation) {
    matrix.method_46416((float)translation.x, (float)translation.y, (float)translation.z);
  }
}
