package dev.greencat.shimmer.module.modules.misc;

package .tmp;

import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.ModeSetting;

public class Translator extends Module {
  public final ModeSetting language = new ModeSetting("Language", "Traget language", "Chinese", new String[] { "Chinese", "Japanese" });
  
  private String prevLanguage;
  
  private static TranslatorImpl translator = null;
  
  private long lastCheck = 0L;
  
  private long lastClear = 0L;
  
  public Translator() {
    super("Translator", "Translator your skyblock item name", -1, Module.Category.MISC);
    addSettings(new Setting[] { (Setting)this.language });
    this.prevLanguage = this.language.getMode();
    translator = new TranslatorImpl(getTranslateFileName(this.language.getMode()));
  }
  
  private String getTranslateFileName(String mode) {
    if (mode.equals("Chinese"))
      return "zh_CN"; 
    if (mode.equals("Japanese"))
      return "ja_JP"; 
    return null;
  }
  
  @ShimmerSubscribe
  public void onTick(TickEvent event) {
    if (System.currentTimeMillis() - this.lastCheck > 10000L && 
      !this.prevLanguage.equals(this.language.getMode())) {
      this.lastCheck = System.currentTimeMillis();
      this.prevLanguage = this.language.getMode();
      translator = new TranslatorImpl(getTranslateFileName(this.language.getMode()));
    } 
    if (System.currentTimeMillis() - this.lastClear >= 480000L && 
      translator != null)
      translator.translationCache.clear(); 
  }
  
  public static String translate(String str) {
    return (translator == null) ? str : translator.translateItemName(str);
  }
}
