package dev.greencat.shimmer.module.modules.misc;

package .tmp;

import dev.greencat.shimmer.module.modules.misc.Translator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

class TranslatorImpl {
  private final Properties reforgeTranslate;
  
  private final Properties itemNameTranslate;
  
  private final List<String> sortedReforgeKeys;
  
  private final List<String> sortedItemNameKeys;
  
  public final String name;
  
  private boolean isAvailable = true;
  
  private final HashMap<String, String> translationCache = new HashMap<>();
  
  public TranslatorImpl(String name) {
    this.name = name;
    this.reforgeTranslate = new Properties();
    this.itemNameTranslate = new Properties();
    InputStream reforgeProperties = Translator.class.getResourceAsStream("/assets/" + name + "/reforge.properties");
    InputStream itemNameProperties = Translator.class.getResourceAsStream("/assets/" + name + "/item.properties");
    try {
      this.reforgeTranslate.load(new InputStreamReader(reforgeProperties, StandardCharsets.UTF_8));
      this.itemNameTranslate.load(new InputStreamReader(itemNameProperties, StandardCharsets.UTF_8));
    } catch (Exception e) {
      e.printStackTrace();
      this.isAvailable = false;
    } 
    this

      
      .sortedReforgeKeys = (List<String>)this.reforgeTranslate.keySet().stream().map(Object::toString).sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
    this

      
      .sortedItemNameKeys = (List<String>)this.itemNameTranslate.keySet().stream().map(Object::toString).sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
  }
  
  public String translateItemName(String name) {
    String result;
    if (name == null || !this.isAvailable || name.isEmpty())
      return name; 
    if (this.translationCache.containsKey(name))
      return this.translationCache.get(name); 
    String originalNameTemp = name;
    String nameTemp = null;
    for (String targetName : this.sortedItemNameKeys) {
      if (!(targetName instanceof String))
        continue; 
      if (originalNameTemp.contains(targetName.toString())) {
        nameTemp = targetName;
        originalNameTemp = originalNameTemp.replace(targetName.toString(), "");
        break;
      } 
    } 
    String reforgeTemp = null;
    for (String reforge : this.sortedReforgeKeys) {
      if (!(reforge instanceof String))
        continue; 
      if (originalNameTemp.contains(String.valueOf(reforge) + " ")) {
        reforgeTemp = reforge;
        break;
      } 
    } 
    String originalString = (reforgeTemp == null) ? nameTemp : (reforgeTemp + " " + reforgeTemp);
    if (nameTemp != null) {
      String finalString = (reforgeTemp == null) ? this.itemNameTranslate.getProperty(nameTemp) : (this.reforgeTranslate.getProperty(reforgeTemp) + " " + this.reforgeTranslate.getProperty(reforgeTemp));
      result = name.replace(originalString, finalString);
    } else {
      result = name;
    } 
    this.translationCache.put(name, result);
    return result;
  }
}
