package dev.greencat.shimmer.module.modules.misc;

package .tmp;

import dev.greencat.shimmer.module.Module;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class RainTimer extends Module {
  public RainTimer() {
    super("RainTimer", "The timer for spider den rain", -1, Module.Category.MISC);
  }
  
  private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
  
  private static final int cooldown = 2400;
  
  private static final int duration = 1200;
  
  private static final int thunderstormInterval = 3;
  
  private static String displayTimeLeft = secsToTime(0L);
  
  private static String displayNextRain = secsToTime(0L);
  
  private static boolean netxIsStormCache;
  
  private static boolean thunderStormNowCache;
  
  private static boolean rainNowCache;
  
  private static String secsToTime(long seconds) {
    return sdf.format(new Date(seconds * 1000L)).substring(14, 19);
  }
  
  public static class_2561 getStringForRenderAndUpdate() {
    class_5250 class_5250;
    class_2561 displayText = null;
    if (netxIsStormCache) {
      class_5250 = class_2561.method_43470("下一场雷雨").method_10852((class_2561)class_2561.method_43470(": " + displayNextRain + "⚡")).method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
    } else if (thunderStormNowCache) {
      class_5250 = class_2561.method_43470("这场雨持续时长").method_10852((class_2561)class_2561.method_43470(": " + displayTimeLeft + "⚡")).method_27696(class_2583.field_24360.method_10977(class_124.field_1065));
    } else if (rainNowCache) {
      class_5250 = class_2561.method_43470("这场雨持续时长").method_10852((class_2561)class_2561.method_43470(": " + displayTimeLeft)).method_27696(class_2583.field_24360.method_10977(class_124.field_1075));
    } else {
      class_5250 = class_2561.method_43470("下一场雨").method_10852((class_2561)class_2561.method_43470(": " + displayNextRain));
    } 
    long timestamp = (long)Math.floor(System.currentTimeMillis() / 1000.0D);
    long skyblockAge = timestamp - 1560275700L;
    long thunderstorm = skyblockAge % 10800L;
    long rain = skyblockAge % 3600L;
    boolean rainNow = false;
    if (2400L <= rain) {
      rainNow = true;
      long timeLeft = 3600L - rain;
      displayTimeLeft = secsToTime(timeLeft);
      displayNextRain = secsToTime(timeLeft + 2400L);
    } else {
      rainNow = false;
      displayNextRain = secsToTime(2400L - rain);
    } 
    boolean thunderStormNow = false;
    boolean netxIsStorm = false;
    if (2400L <= thunderstorm && thunderstorm < 3600L) {
      thunderStormNow = true;
      long timeLeft = 3600L - rain;
      displayTimeLeft = secsToTime(timeLeft);
    } else {
      thunderStormNow = false;
      long nextThunderstorm = 0L;
      if (thunderstorm < 2400L) {
        nextThunderstorm = 2400L - thunderstorm;
      } else if (3600L <= thunderstorm) {
        nextThunderstorm = 10800L - thunderstorm + 2400L;
      } 
      if (nextThunderstorm == 2400L - rain) {
        netxIsStorm = true;
        displayNextRain = secsToTime(nextThunderstorm);
      } else {
        netxIsStorm = false;
      } 
    } 
    thunderStormNowCache = thunderStormNow;
    rainNowCache = rainNow;
    netxIsStormCache = netxIsStorm;
    return (class_2561)class_5250;
  }
}
