package dev.greencat.shimmer.module.modules.misc;

package .tmp;

import dev.greencat.shimmer.event.events.LivingEntityRenderPreEvent;
import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import dev.greencat.shimmer.util.render.TextRenderUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5251;

public class DamageSplash extends Module {
  public final BooleanSetting damageSplashCompact = new BooleanSetting("Damage Splash Compact", "Compact your damage number,example:1,500,000 to 1.5M", false);
  
  public final NumberSetting damageSplashOffset = new NumberSetting("Damage Splash Offset", "Move you damage splash randomly", 2.0D, 0.0D, 5.0D, 0.01D);
  
  public final NumberSetting damageSplashAnimationSpeed = new NumberSetting("Damage Splash Animation Speed", "Change the spawn speed", 0.3D, 0.0D, 2.0D, 0.01D);
  
  public final NumberSetting damageSplashDuration = new NumberSetting("Damage Splash Duration", "Change the duration", 3.0D, 0.0D, 10.0D, 0.01D);
  
  public final BooleanSetting damageSplashCombine = new BooleanSetting("Damage Splash Combine", "Combine nearly splash text", true);
  
  public DamageSplash() {
    super("DamageSplash", "Make your damage splash better", -1, Module.Category.MISC);
    addSettings(new Setting[] { (Setting)this.damageSplashCompact, (Setting)this.damageSplashOffset, (Setting)this.damageSplashAnimationSpeed, (Setting)this.damageSplashDuration, (Setting)this.damageSplashCombine });
  }
  
  private static final Pattern pattern = Pattern.compile("[✧✯]?(\\d{1,3}(?:,\\d{3})*[⚔+✧❤♞☄✷ﬗ✯]*)");
  
  private static final Deque<RenderInformation> damages = new LinkedList<>();
  
  private static final List<class_1309> removeList = new LinkedList<>();
  
  private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");
  
  private static final Random random = new Random();
  
  @ShimmerSubscribe
  public boolean onRenderEntity(LivingEntityRenderPreEvent event) {
    for (class_1297 e : removeList) {
      if ((class_310.method_1551()).field_1687 != null)
        (class_310.method_1551()).field_1687.method_2945(e.method_5628(), class_1297.class_5529.field_27001); 
    } 
    removeList.clear();
    class_1309 entity = event.entity;
    if (entity instanceof net.minecraft.class_1531 && entity.method_16914()) {
      String customName = entity.method_5797().getString();
      Matcher matcher = pattern.matcher((customName == null) ? "" : customName);
      if (matcher.matches() && customName != null) {
        String damage = customName.replaceAll("[^\\d]", "");
        long damageInteger = Long.parseLong(damage);
        if (this.damageSplashCompact.isEnabled())
          try {
            if (damageInteger >= 1000L && damageInteger < 1000000L) {
              double damageDouble = damageInteger / 1000.0D;
              damage = decimalFormat.format(damageDouble) + "K";
            } else if (damageInteger >= 1000000L && damageInteger < 1000000000L) {
              double damageDouble = damageInteger / 1000000.0D;
              damage = decimalFormat.format(damageDouble) + "M";
            } else if (damageInteger >= 1000000000L) {
              double damageDouble = damageInteger / 1.0E9D;
              damage = decimalFormat.format(damageDouble) + "B";
            } 
          } catch (Exception exception) {} 
        RenderInformation info = new RenderInformation(entity.method_23317() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0D) - this.damageSplashOffset.getValue(), entity.method_23318() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0D) - this.damageSplashOffset.getValue(), entity.method_23321() + random.nextDouble(this.damageSplashOffset.getValue() * 2.0D) - this.damageSplashOffset.getValue(), damage, new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255)), damageInteger);
        boolean combined = false;
        if (this.damageSplashCombine.isEnabled())
          for (RenderInformation entry : damages) {
            if (Math.sqrt((info.x - entry.x) * (info.x - entry.x) + (info.y - entry.y) * (info.y - entry.y) + info.z - entry.z) <= 1.75D + this.damageSplashOffset.getValue()) {
              combined = true;
              entry.startTime = (long)(System.currentTimeMillis() - this.damageSplashAnimationSpeed.getValue() * 1000.0D);
              entry.damage += damageInteger;
              String dmgStr = String.valueOf(entry.damage);
              if (this.damageSplashCompact.isEnabled())
                try {
                  if (entry.damage >= 1000L && entry.damage < 1000000L) {
                    double damageDouble = entry.damage / 1000.0D;
                    dmgStr = decimalFormat.format(damageDouble) + "K";
                  } else if (entry.damage >= 1000000L && entry.damage < 1000000000L) {
                    double damageDouble = entry.damage / 1000000.0D;
                    dmgStr = decimalFormat.format(damageDouble) + "M";
                  } else if (entry.damage >= 1000000000L) {
                    double damageDouble = entry.damage / 1.0E9D;
                    dmgStr = decimalFormat.format(damageDouble) + "B";
                  } 
                } catch (Exception exception) {} 
              entry.message = dmgStr;
              break;
            } 
          }  
        if (!combined)
          damages.add(info); 
        removeList.add(entity);
        return false;
      } 
    } 
    return true;
  }
  
  @ShimmerSubscribe
  public void onRenderWorld(RenderEvent.Post event) {
    if ((class_310.method_1551()).field_1724 == null) {
      damages.clear();
      return;
    } 
    WorldRenderContext wrc = event.wrc;
    List<RenderInformation> removeList = new ArrayList<>();
    for (RenderInformation info : damages) {
      class_243 pos = new class_243(info.x, info.y, info.z);
      float scaling = (float)Math.max(2.0D, Math.log(pos.method_1022((class_310.method_1551()).field_1724.method_19538()) * 3.0D));
      TextRenderUtil.renderText(wrc, (class_2561)class_2561.method_43470(info.message).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717(info.color.getRGB()))), pos, (float)(((System.currentTimeMillis() - info.startTime) <= this.damageSplashAnimationSpeed.getValue() * 1000.0D) ? ((System.currentTimeMillis() - info.startTime) / this.damageSplashAnimationSpeed.getValue() * 1000.0D * scaling) : scaling), true, wrc.consumers());
      if ((System.currentTimeMillis() - info.startTime) >= this.damageSplashDuration.getValue() * 1000.0D)
        removeList.add(info); 
    } 
    if (!removeList.isEmpty())
      damages.removeAll(removeList); 
  }
}
