package dev.greencat.shimmer.module.modules.misc;

package .tmp;

import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.util.AuctionItem;
import dev.greencat.shimmer.util.HaikuLogger;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class AuctionTracker extends Module {
  public static final List<AuctionItem> cowList = new CopyOnWriteArrayList<>();
  
  public static final HashMap<String, class_124> colorMap = new HashMap<>();
  
  private static final Random random = new Random();
  
  private long lastSend = 0L;
  
  private int lastRandom = 500;
  
  public static final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
  
  static {
    colorMap.put("COMMON", class_124.field_1068);
    colorMap.put("UNCOMMON", class_124.field_1060);
    colorMap.put("RARE", class_124.field_1078);
    colorMap.put("EPIC", class_124.field_1064);
    colorMap.put("LEGENDARY", class_124.field_1065);
    colorMap.put("MYTHIC", class_124.field_1076);
    colorMap.put("DIVINE", class_124.field_1075);
    colorMap.put("SPECIAL", class_124.field_1061);
    colorMap.put("VERY_SPECIAL", class_124.field_1061);
    colorMap.put("ULTIMATE", class_124.field_1079);
  }
  
  public static final BooleanSetting ignoreDungeonRubbish = new BooleanSetting("Ignore Rubbish", "Ignore the dungeon rubbish", true);
  
  public static final BooleanSetting ignoreFish = new BooleanSetting("Ignore \"the Fish\"", "Ignore the fish", true);
  
  public static final BooleanSetting ignore_COMMON = new BooleanSetting("Ignore COMMON", "Ignore COMMON", false);
  
  public static final BooleanSetting ignore_UNCOMMON = new BooleanSetting("Ignore UNCOMMON", "Ignore UNCOMMON", false);
  
  public static final BooleanSetting ignore_RARE = new BooleanSetting("Ignore RARE", "Ignore RARE", false);
  
  public AuctionTracker() {
    super("AuctionTracker", "Auto track the item in auction house", -1, Module.Category.MISC);
    addSettings(new Setting[] { (Setting)ignoreDungeonRubbish, (Setting)ignoreFish, (Setting)ignore_COMMON, (Setting)ignore_UNCOMMON, (Setting)ignore_RARE });
  }
  
  @ShimmerSubscribe
  public void onTick(TickEvent event) {
    if ((class_310.method_1551()).field_1687 == null || (class_310.method_1551()).field_1724 == null)
      return; 
    if (cowList.isEmpty())
      return; 
    if (System.currentTimeMillis() - this.lastSend <= this.lastRandom)
      return; 
    this.lastRandom = 500 + random.nextInt(1500) - 750;
    this.lastSend = System.currentTimeMillis();
    AuctionItem item = cowList.getFirst();
    class_124 itemColor = colorMap.getOrDefault(item.tier, class_124.field_1054);
    class_5250 text = class_2561.method_43470(String.valueOf(itemColor) + String.valueOf(itemColor) + item.name + " | " + String.valueOf(class_124.field_1068) + String.valueOf(class_124.field_1065));
    class_2583 clickStyle = class_2583.field_24360.method_10958((class_2558)new class_2558.class_10609("viewauction " + item.uid));
    class_5250 clickable = class_2561.method_43470(String.valueOf(class_124.field_1054) + " CLICK").method_27696(clickStyle);
    text.method_10852((class_2561)clickable);
    cowList.remove(item);
    if (isAvailable(item))
      HaikuLogger.auctionTracker((class_2561)text); 
  }
  
  private static boolean isAvailable(AuctionItem item) {
    if (ignoreFish.isEnabled() && item.name.contains("the Fish"))
      return false; 
    if (ignore_COMMON.isEnabled() && item.tier.equals("COMMON"))
      return false; 
    if (ignore_UNCOMMON.isEnabled() && item.tier.equals("UNCOMMON"))
      return false; 
    if (ignore_RARE.isEnabled() && item.tier.equals("RARE"))
      return false; 
    if (ignoreDungeonRubbish.isEnabled() && (item.name.contains(" Heavy ") || item.name.contains("Skeleton Grunt") || item.name.contains("Rotten") || item.name.contains("Soldier") || item.name.contains("Skeleton Master") || item.name.contains("Zombie Knight") || item.name.contains("Dreadlord") || item.name.contains("Machine Gun") || item.name.contains("Soulstealer") || item.name.contains("Conjuring")))
      return false; 
    return true;
  }
}
