package dev.greencat.shimmer.module.modules.macro;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.modules.combat.Killaura;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import dev.greencat.shimmer.util.player.PlayerUtil;
import dev.greencat.shimmer.util.player.WalkerUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_2482;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3532;

public class KillerBot extends Module {
  public final ModeSetting mode = new ModeSetting("Mob Type", "Choose the mob type you want to kill", "Crypt", new String[] { "Crypt", "Zombie", "Wolf", "Spider", "Enderman", "MagmaCube", "Glacite Walker", "Goblin" });
  
  private final List<class_1309> blacklist;
  
  private class_1309 prevTarget;
  
  private long lastSearch;
  
  private int count;
  
  public KillerBot() {
    super("KillerBot", "Kill mob automatically", -1, Module.Category.MACRO);
    this.blacklist = new ArrayList<>();
    this.prevTarget = null;
    this.lastSearch = 0L;
    this.count = 0;
    addSettings(new Setting[] { (Setting)this.mode });
    this.needDisable = true;
  }
  
  @ShimmerSubscribe
  public void onTick(TickEvent event) {
    if (mc.field_1724 == null || mc.field_1687 == null)
      return; 
    if (this.count > 3)
      this.blacklist.add(this.prevTarget); 
    List<class_1309> withInList = new ArrayList<>();
    for (class_1297 entity : mc.field_1687.method_18112()) {
      class_238 hitbox = entity.method_5829();
      if (entity instanceof class_1309 && PlayerUtil.isWithin(
          class_3532.method_15350(mc.field_1724.method_23317(), hitbox.field_1323, hitbox.field_1320), 
          class_3532.method_15350(mc.field_1724.method_23318(), hitbox.field_1322, hitbox.field_1325), 
          class_3532.method_15350(mc.field_1724.method_23321(), hitbox.field_1321, hitbox.field_1324), 2.5D) && 
        PlayerUtil.canSeeEntity(entity) && 
        checkMob((class_1309)entity))
        withInList.add((class_1309)entity); 
    } 
    if (withInList.isEmpty() && !WalkerUtils.isActive()) {
      class_1309 target = getNearestMob();
      if (target == null)
        return; 
      if (this.prevTarget == null || !this.prevTarget.equals(target)) {
        this.prevTarget = target;
        this.count = 0;
      } 
      if (System.currentTimeMillis() - this.lastSearch >= 2000L) {
        this.lastSearch = System.currentTimeMillis();
        if (mc.field_1687.method_8320(target.method_24515()).method_26204() instanceof class_2482 && mc.field_1687.method_8320(target.method_24515()).method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
          WalkerUtils.walkTo(target.method_24515());
        } else if (this.mode.equals("Goblin") || this.mode.equals("Glacite Walker")) {
          WalkerUtils.walkTo(target.method_24515().method_10087(2));
        } else {
          WalkerUtils.walkTo(target.method_24515().method_10074());
        } 
        this.count++;
      } 
    } 
    if (!withInList.isEmpty() && WalkerUtils.isActive())
      WalkerUtils.cancel(); 
    if (!withInList.isEmpty())
      this.lastSearch = System.currentTimeMillis() - 3000L; 
    Shimmer.getInstance().getModuleManager().getModule("Killaura").setEnabled(!withInList.isEmpty());
  }
  
  public boolean checkMob(class_1309 entity) {
    // Byte code:
    //   0: aload_1
    //   1: getstatic dev/greencat/shimmer/module/modules/macro/KillerBot.mc : Lnet/minecraft/class_310;
    //   4: getfield field_1724 : Lnet/minecraft/class_746;
    //   7: invokevirtual equals : (Ljava/lang/Object;)Z
    //   10: ifne -> 26
    //   13: aload_1
    //   14: getstatic dev/greencat/shimmer/module/modules/macro/KillerBot.mc : Lnet/minecraft/class_310;
    //   17: getfield field_1719 : Lnet/minecraft/class_1297;
    //   20: invokevirtual equals : (Ljava/lang/Object;)Z
    //   23: ifeq -> 28
    //   26: iconst_0
    //   27: ireturn
    //   28: aload_1
    //   29: instanceof net/minecraft/class_1309
    //   32: ifeq -> 44
    //   35: aload_1
    //   36: astore_2
    //   37: aload_2
    //   38: invokevirtual method_29504 : ()Z
    //   41: ifne -> 51
    //   44: aload_1
    //   45: invokevirtual method_5805 : ()Z
    //   48: ifne -> 53
    //   51: iconst_0
    //   52: ireturn
    //   53: aload_1
    //   54: getstatic dev/greencat/shimmer/module/modules/macro/KillerBot.mc : Lnet/minecraft/class_310;
    //   57: getfield field_1724 : Lnet/minecraft/class_746;
    //   60: invokevirtual equals : (Ljava/lang/Object;)Z
    //   63: ifne -> 79
    //   66: aload_1
    //   67: getstatic dev/greencat/shimmer/module/modules/macro/KillerBot.mc : Lnet/minecraft/class_310;
    //   70: getfield field_1719 : Lnet/minecraft/class_1297;
    //   73: invokevirtual equals : (Ljava/lang/Object;)Z
    //   76: ifeq -> 81
    //   79: iconst_0
    //   80: ireturn
    //   81: aload_1
    //   82: instanceof net/minecraft/class_1309
    //   85: ifeq -> 97
    //   88: aload_1
    //   89: astore_2
    //   90: aload_2
    //   91: invokevirtual method_29504 : ()Z
    //   94: ifne -> 104
    //   97: aload_1
    //   98: invokevirtual method_5805 : ()Z
    //   101: ifne -> 106
    //   104: iconst_0
    //   105: ireturn
    //   106: aload_1
    //   107: instanceof net/minecraft/class_1309
    //   110: ifeq -> 144
    //   113: aload_1
    //   114: astore_2
    //   115: aload_2
    //   116: invokevirtual method_5767 : ()Z
    //   119: ifeq -> 144
    //   122: aload_2
    //   123: instanceof net/minecraft/class_1531
    //   126: ifne -> 144
    //   129: aload_0
    //   130: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   133: ldc_w 'Ghost'
    //   136: invokevirtual equals : (Ljava/lang/String;)Z
    //   139: ifne -> 144
    //   142: iconst_0
    //   143: ireturn
    //   144: aload_1
    //   145: instanceof net/minecraft/class_1309
    //   148: ifeq -> 162
    //   151: aload_1
    //   152: astore_2
    //   153: aload_2
    //   154: invokevirtual method_5805 : ()Z
    //   157: ifne -> 162
    //   160: iconst_0
    //   161: ireturn
    //   162: aload_1
    //   163: instanceof net/minecraft/class_1309
    //   166: ifeq -> 180
    //   169: aload_1
    //   170: astore_2
    //   171: aload_2
    //   172: invokevirtual method_5732 : ()Z
    //   175: ifne -> 180
    //   178: iconst_0
    //   179: ireturn
    //   180: aload_0
    //   181: getfield blacklist : Ljava/util/List;
    //   184: aload_1
    //   185: invokeinterface contains : (Ljava/lang/Object;)Z
    //   190: ifeq -> 195
    //   193: iconst_0
    //   194: ireturn
    //   195: aload_0
    //   196: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   199: ldc 'Crypt'
    //   201: invokevirtual equals : (Ljava/lang/String;)Z
    //   204: ifeq -> 231
    //   207: aload_1
    //   208: instanceof net/minecraft/class_1642
    //   211: ifeq -> 229
    //   214: aload_1
    //   215: invokevirtual method_23318 : ()D
    //   218: ldc2_w 70.0
    //   221: dcmpg
    //   222: ifgt -> 229
    //   225: iconst_1
    //   226: goto -> 230
    //   229: iconst_0
    //   230: ireturn
    //   231: aload_0
    //   232: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   235: ldc 'Zombie'
    //   237: invokevirtual equals : (Ljava/lang/String;)Z
    //   240: ifeq -> 267
    //   243: aload_1
    //   244: instanceof net/minecraft/class_1642
    //   247: ifeq -> 265
    //   250: aload_1
    //   251: invokevirtual method_23318 : ()D
    //   254: ldc2_w 70.0
    //   257: dcmpl
    //   258: ifle -> 265
    //   261: iconst_1
    //   262: goto -> 266
    //   265: iconst_0
    //   266: ireturn
    //   267: aload_0
    //   268: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   271: ldc 'Wolf'
    //   273: invokevirtual equals : (Ljava/lang/String;)Z
    //   276: ifeq -> 284
    //   279: aload_1
    //   280: instanceof net/minecraft/class_1493
    //   283: ireturn
    //   284: aload_0
    //   285: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   288: ldc 'Enderman'
    //   290: invokevirtual equals : (Ljava/lang/String;)Z
    //   293: ifeq -> 301
    //   296: aload_1
    //   297: instanceof net/minecraft/class_1560
    //   300: ireturn
    //   301: aload_0
    //   302: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   305: ldc 'Spider'
    //   307: invokevirtual equals : (Ljava/lang/String;)Z
    //   310: ifeq -> 318
    //   313: aload_1
    //   314: instanceof net/minecraft/class_1628
    //   317: ireturn
    //   318: aload_0
    //   319: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   322: ldc 'MagmaCube'
    //   324: invokevirtual equals : (Ljava/lang/String;)Z
    //   327: ifeq -> 355
    //   330: aload_1
    //   331: instanceof net/minecraft/class_1589
    //   334: ifeq -> 353
    //   337: aload_1
    //   338: checkcast net/minecraft/class_1589
    //   341: astore_2
    //   342: aload_2
    //   343: invokevirtual method_5782 : ()Z
    //   346: ifne -> 353
    //   349: iconst_1
    //   350: goto -> 354
    //   353: iconst_0
    //   354: ireturn
    //   355: aload_0
    //   356: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   359: ldc 'Glacite Walker'
    //   361: invokevirtual equals : (Ljava/lang/String;)Z
    //   364: ifeq -> 422
    //   367: aload_1
    //   368: invokevirtual method_16914 : ()Z
    //   371: ifeq -> 420
    //   374: aload_1
    //   375: instanceof net/minecraft/class_1531
    //   378: ifeq -> 420
    //   381: aload_1
    //   382: invokevirtual method_5797 : ()Lnet/minecraft/class_2561;
    //   385: invokeinterface getString : ()Ljava/lang/String;
    //   390: ldc 'Glacite Walker'
    //   392: invokevirtual contains : (Ljava/lang/CharSequence;)Z
    //   395: ifeq -> 420
    //   398: aload_1
    //   399: invokevirtual method_5797 : ()Lnet/minecraft/class_2561;
    //   402: invokeinterface getString : ()Ljava/lang/String;
    //   407: ldc_w '0'
    //   410: invokevirtual contains : (Ljava/lang/CharSequence;)Z
    //   413: ifne -> 420
    //   416: iconst_1
    //   417: goto -> 421
    //   420: iconst_0
    //   421: ireturn
    //   422: aload_0
    //   423: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   426: ldc 'Goblin'
    //   428: invokevirtual equals : (Ljava/lang/String;)Z
    //   431: ifeq -> 525
    //   434: aload_1
    //   435: invokevirtual method_16914 : ()Z
    //   438: ifeq -> 523
    //   441: aload_1
    //   442: instanceof net/minecraft/class_1531
    //   445: ifeq -> 523
    //   448: aload_1
    //   449: invokevirtual method_5797 : ()Lnet/minecraft/class_2561;
    //   452: invokeinterface getString : ()Ljava/lang/String;
    //   457: ldc 'Goblin'
    //   459: invokevirtual contains : (Ljava/lang/CharSequence;)Z
    //   462: ifne -> 501
    //   465: aload_1
    //   466: invokevirtual method_5797 : ()Lnet/minecraft/class_2561;
    //   469: invokeinterface getString : ()Ljava/lang/String;
    //   474: ldc_w 'Knifethrower'
    //   477: invokevirtual contains : (Ljava/lang/CharSequence;)Z
    //   480: ifne -> 501
    //   483: aload_1
    //   484: invokevirtual method_5797 : ()Lnet/minecraft/class_2561;
    //   487: invokeinterface getString : ()Ljava/lang/String;
    //   492: ldc_w 'Fireslinger'
    //   495: invokevirtual contains : (Ljava/lang/CharSequence;)Z
    //   498: ifeq -> 523
    //   501: aload_1
    //   502: invokevirtual method_5797 : ()Lnet/minecraft/class_2561;
    //   505: invokeinterface getString : ()Ljava/lang/String;
    //   510: ldc_w '800/800'
    //   513: invokevirtual contains : (Ljava/lang/CharSequence;)Z
    //   516: ifeq -> 523
    //   519: iconst_1
    //   520: goto -> 524
    //   523: iconst_0
    //   524: ireturn
    //   525: iconst_0
    //   526: ireturn
    // Line number table:
    //   Java source line number -> byte code offset
    //   #94	-> 0
    //   #95	-> 28
    //   #96	-> 53
    //   #97	-> 81
    //   #98	-> 106
    //   #99	-> 142
    //   #101	-> 144
    //   #102	-> 160
    //   #104	-> 162
    //   #105	-> 178
    //   #107	-> 180
    //   #108	-> 193
    //   #110	-> 195
    //   #111	-> 207
    //   #113	-> 231
    //   #114	-> 243
    //   #116	-> 267
    //   #117	-> 279
    //   #119	-> 284
    //   #120	-> 296
    //   #122	-> 301
    //   #123	-> 313
    //   #125	-> 318
    //   #126	-> 330
    //   #128	-> 355
    //   #129	-> 367
    //   #131	-> 422
    //   #132	-> 434
    //   #134	-> 525
    // Local variable table:
    //   start	length	slot	name	descriptor
    //   37	7	2	livingEntity	Lnet/minecraft/class_1309;
    //   90	7	2	livingEntity	Lnet/minecraft/class_1309;
    //   115	29	2	livingEntity	Lnet/minecraft/class_1309;
    //   153	9	2	livingEntity	Lnet/minecraft/class_1309;
    //   171	9	2	livingEntity	Lnet/minecraft/class_1309;
    //   342	11	2	magmaCube	Lnet/minecraft/class_1589;
    //   0	527	0	this	Ldev/greencat/shimmer/module/modules/macro/KillerBot;
    //   0	527	1	entity	Lnet/minecraft/class_1309;
  }
  
  public class_1309 getNearestMob() {
    List<class_1309> targetList = new ArrayList<>();
    for (class_1297 entity : mc.field_1687.method_18112()) {
      if (entity instanceof class_1309) {
        class_1309 livingEntity = (class_1309)entity;
        if (checkMob(livingEntity))
          targetList.add((class_1309)entity); 
      } 
    } 
    targetList.sort(Comparator.comparingDouble(PlayerUtil::squaredDistanceTo));
    return targetList.isEmpty() ? null : targetList.getFirst();
  }
  
  public void onEnable() {
    super.onEnable();
    if (this.mode.equals("Goblin") || this.mode.equals("Glacite Walker"))
      ((Killaura)Shimmer.getInstance().getModuleManager().getModule("Killaura")).checkTeam.setEnabled(false); 
  }
  
  public void onDisable() {
    super.onDisable();
    ((Killaura)Shimmer.getInstance().getModuleManager().getModule("Killaura")).checkTeam.setEnabled(true);
    WalkerUtils.cancel();
  }
}
