package dev.greencat.shimmer.module.modules.macro;

package .tmp;

import dev.greencat.shimmer.event.events.BackgroundDrawnEvent;
import dev.greencat.shimmer.event.events.OnScreenOpenEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.BooleanSetting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class ExperimentBot extends Module {
  class_310 mc = class_310.method_1551();
  
  private final NumberSetting delay = new NumberSetting("Delay", "Click Delay", 200.0D, 0.0D, 1000.0D, 0.1D);
  
  private final BooleanSetting autoExit = new BooleanSetting("Auto Exit", "Auto exit experiment table when got all superpair clicks", true);
  
  private ExperimentType currentExperiment = ExperimentType.NONE;
  
  private boolean hasAdded = false;
  
  private int clicks = 0;
  
  private long lastClickTime = 0L;
  
  private final List<Map.Entry<Integer, String>> chronomatronOrder = new ArrayList<>(28);
  
  private int lastAdded = 0;
  
  private final HashMap<Integer, Integer> ultrasequencerOrder = new HashMap<>();
  
  public ExperimentBot() {
    super("ExperimentsBot", "Auto finish experiment table", -1, Module.Category.MACRO);
    addSettings(new Setting[] { (Setting)this.delay, (Setting)this.autoExit });
  }
  
  @ShimmerSubscribe
  public void onGuiOpen(OnScreenOpenEvent event) {
    class_476 container;
    this.currentExperiment = ExperimentType.NONE;
    this.hasAdded = false;
    this.chronomatronOrder.clear();
    this.lastAdded = 0;
    this.ultrasequencerOrder.clear();
    class_437 class_437 = event.getScreen();
    if (class_437 instanceof class_476) {
      container = (class_476)class_437;
    } else {
      return;
    } 
    String chestName = container.method_25440().getString();
    if (chestName.contains("Chronomatron") && !chestName.contains("Sta")) {
      this.currentExperiment = ExperimentType.CHRONOMATRON;
    } else if (chestName.contains("Ultrasequencer") && !chestName.contains("Sta")) {
      this.currentExperiment = ExperimentType.ULTRASEQUENCER;
    } else if (chestName.startsWith("Superpairs (")) {
      this.currentExperiment = ExperimentType.SUPERPAIRS;
    } 
  }
  
  @ShimmerSubscribe
  public void onGuiDraw(BackgroundDrawnEvent event) {
    class_476 container;
    class_437 class_437 = event.getScreen();
    if (class_437 instanceof class_476) {
      container = (class_476)class_437;
    } else {
      return;
    } 
    class_2371<class_1735> class_2371 = ((class_1707)container.method_17577()).field_7761;
    switch (this.currentExperiment.ordinal()) {
      case 0:
        if (((class_1735)class_2371.get(49)).method_7677() != null && ((class_1735)class_2371.get(49)).method_7677().method_7909() == class_1792.method_7867(class_2246.field_10171) && !((class_1735)class_2371.get(this.lastAdded)).method_7677().method_7958()) {
          this.hasAdded = false;
          if (this.chronomatronOrder.size() > 12 && this.autoExit.isEnabled())
            class_310.method_1551().method_1507(null); 
        } 
        if (!this.hasAdded && ((class_1735)class_2371.get(49)).method_7677() != null && ((class_1735)class_2371.get(49)).method_7677().method_7909() == class_1802.field_8557) {
          Optional<class_1735> optional = class_2371.stream().filter(it -> (it.field_7874 >= 10 && it.field_7874 <= 43)).filter(item -> item.method_7677().method_7958()).findFirst();
          if (optional.isPresent()) {
            class_1735 slot = optional.get();
            this.chronomatronOrder.add(new AbstractMap.SimpleEntry<>(Integer.valueOf(slot.field_7874), slot.method_7677().method_7964().getString()));
            this.lastAdded = slot.field_7874;
            this.hasAdded = true;
            this.clicks = 0;
          } 
        } 
        if (this.hasAdded && ((class_1735)class_2371.get(49)).method_7677().method_7909() == class_1802.field_8557 && this.chronomatronOrder.size() > this.clicks && (System.currentTimeMillis() - this.lastClickTime) > this.delay.getValue()) {
          this.mc.field_1761.method_2906(((class_1707)container.method_17577()).field_7763, ((Integer)((Map.Entry)this.chronomatronOrder.get(this.clicks)).getKey()).intValue(), 0, class_1713.field_7796, (class_1657)this.mc.field_1724);
          this.lastClickTime = System.currentTimeMillis();
          this.clicks++;
        } 
        break;
      case 1:
        if (((class_1735)class_2371.get(49)).method_7677().method_7909() == class_1802.field_8557)
          this.hasAdded = false; 
        if (!this.hasAdded && ((class_1735)class_2371.get(49)).method_7677().method_7909() == class_1792.method_7867(class_2246.field_10171)) {
          if (!((class_1735)class_2371.get(44)).method_7681())
            return; 
          this.ultrasequencerOrder.clear();
          class_2371.stream().filter(it -> (it.field_7874 >= 9 && it.field_7874 <= 44)).forEach(this::setUltraSequencerOrder);
          this.hasAdded = true;
          this.clicks = 0;
          if (this.ultrasequencerOrder.size() > 10 && this.autoExit.isEnabled())
            class_310.method_1551().method_1507(null); 
        } 
        if (((class_1735)class_2371.get(49)).method_7677() != null && ((class_1735)class_2371.get(49)).method_7677().method_7909() == class_1802.field_8557 && this.ultrasequencerOrder.containsKey(Integer.valueOf(this.clicks)) && (System.currentTimeMillis() - this.lastClickTime) > this.delay.getValue()) {
          Integer slot = this.ultrasequencerOrder.get(Integer.valueOf(this.clicks));
          if (slot != null)
            this.mc.field_1761.method_2906(((class_1707)container.method_17577()).field_7763, slot.intValue(), 0, class_1713.field_7796, (class_1657)this.mc.field_1724); 
          this.lastClickTime = System.currentTimeMillis();
          this.clicks++;
        } 
        break;
    } 
  }
  
  public void setUltraSequencerOrder(class_1735 slot) {
    if (slot.method_7677() != null && (slot.method_7677().method_7909() instanceof net.minecraft.class_1769 || slot.method_7677().method_7909() == class_1802.field_8759 || slot.method_7677().method_7909() == class_1802.field_8324))
      this.ultrasequencerOrder.put(Integer.valueOf(slot.method_7677().method_7947() - 1), Integer.valueOf(slot.field_7874)); 
  }
}
