package dev.greencat.shimmer.module.modules.macro;

package .tmp;

import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.NumberSetting;
import dev.greencat.shimmer.util.player.WalkerUtils;
import dev.greencat.shimmer.util.player.rotation.RotationUtil;
import dev.greencat.shimmer.util.render.RenderUtil;
import dev.greencat.shimmer.util.world.LocationUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1639;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class DojoHelper extends Module {
  private static final NumberSetting movePredict = new NumberSetting("Move Predict factor", "Change the factor of move predict", 4.75D, 0.0D, 10.0D, 0.01D);
  
  public DojoHelper() {
    super("DojoHelper", "Just a dojo helper", -1, Module.Category.MACRO);
    addSettings(new Setting[] { (Setting)movePredict });
  }
  
  private static final HashSet<class_2338> lastLimePos = new HashSet<>();
  
  private static final HashSet<class_2338> limePos = new HashSet<>();
  
  private static final List<class_1297> blacklist = new ArrayList<>();
  
  private static class_2338 lastWalkPos = null;
  
  private static class_243 lastVec = null;
  
  private static long lastShoot = 0L;
  
  private static class_243 lastNeedFix = new class_243(0.0D, 0.0D, 0.0D);
  
  private static class_2338 furtherTarget = null;
  
  private static List<YellowBlock> yellowPos = new ArrayList<>();
  
  private static long lastRecord = 0L;
  
  @ShimmerSubscribe
  public void onTick(TickEvent event) {
    if ((class_310.method_1551()).field_1724 == null || (class_310.method_1551()).field_1687 == null)
      return; 
    if (isInSwiftness()) {
      limePos.clear();
      if ((class_310.method_1551()).field_1724.method_24515().method_10074().equals(lastWalkPos))
        WalkerUtils.cancel(); 
      class_2338.method_10097(new class_2338((class_310.method_1551()).field_1724.method_31477() + 5, (class_310.method_1551()).field_1724.method_31478() - 1, (class_310.method_1551()).field_1724.method_31479() + 5), new class_2338((class_310.method_1551()).field_1724.method_31477() - 5, (class_310.method_1551()).field_1724.method_31478() - 1, (class_310.method_1551()).field_1724.method_31479() - 5)).forEach(pos -> {
            if ((class_310.method_1551()).field_1687.method_8320(pos).method_26204() == class_2246.field_10028)
              limePos.add(pos.method_10062()); 
          });
      List<class_2338> newPos = new ArrayList<>();
      for (class_2338 pos : limePos) {
        if (!lastLimePos.contains(pos))
          newPos.add(pos); 
      } 
      newPos.remove((class_310.method_1551()).field_1724.method_24515().method_10074());
      if (!newPos.isEmpty()) {
        class_2338 furtherTarget = null;
        double distance = -1.0D;
        for (class_2338 pos : newPos) {
          if (pos.method_19770((class_2374)(class_310.method_1551()).field_1724.method_19538()) > distance) {
            distance = pos.method_19770((class_2374)(class_310.method_1551()).field_1724.method_19538());
            furtherTarget = pos;
          } 
        } 
        newPos.remove(furtherTarget);
        dev.greencat.shimmer.module.modules.macro.DojoHelper.furtherTarget = furtherTarget;
        if (!WalkerUtils.isActive() || furtherTarget != lastWalkPos) {
          WalkerUtils.walkToBaritoneRotation(furtherTarget);
          lastWalkPos = furtherTarget;
        } 
      } 
      lastLimePos.clear();
      lastLimePos.addAll(limePos);
    } else if (!lastLimePos.isEmpty()) {
      lastLimePos.clear();
    } 
    if (isInControl()) {
      class_1639 target = null;
      float distance = 9999.0F;
      for (class_1297 entity : (class_310.method_1551()).field_1687.method_18112()) {
        if (entity instanceof class_1639 && entity.method_5739((class_1297)(class_310.method_1551()).field_1724) < distance && !entity.method_5767() && !blacklist.contains(entity)) {
          distance = entity.method_5739((class_1297)(class_310.method_1551()).field_1724);
          target = (class_1639)entity;
        } 
      } 
      if (target != null) {
        if (target.method_6118(class_1304.field_6169).method_7909() == class_1802.field_8793)
          blacklist.add(target); 
        class_243 needFix = new class_243(0.0D, 0.0D, 0.0D);
        if (lastVec != null)
          needFix = new class_243(movePredict.getValue() * (target.method_23317() - lastVec.method_10216()), 0.5D * (target.method_23318() - lastVec.method_10214()), movePredict.getValue() * (target.method_23321() - lastVec.method_10215())); 
        if (Math.abs(needFix.method_10216()) <= 0.1D && Math.abs(needFix.method_10214()) <= 0.03D && Math.abs(needFix.method_10215()) <= 0.1D) {
          needFix = lastNeedFix;
        } else {
          lastNeedFix = needFix;
        } 
        (class_310.method_1551()).field_1724.method_36456((float)RotationUtil.getYaw(target.method_33571().method_1023(0.0D, 0.3D, 0.0D).method_1019(needFix)));
        (class_310.method_1551()).field_1724.method_36457((float)RotationUtil.getPitch(target.method_33571().method_1023(0.0D, 0.3D, 0.0D).method_1019(needFix)));
        if (System.currentTimeMillis() - lastRecord >= 50L) {
          lastVec = target.method_19538();
          lastRecord = System.currentTimeMillis();
        } 
      } 
    } else if (!blacklist.isEmpty()) {
      blacklist.clear();
    } 
    if (isInMastery()) {
      List<class_2338> currentYellowPos = new ArrayList<>();
      for (class_2338 pos : class_2338.method_10097(new class_2338((class_310.method_1551()).field_1724.method_31477() + 20, (class_310.method_1551()).field_1724.method_31478() + 20, (class_310.method_1551()).field_1724.method_31479() + 20), new class_2338((class_310.method_1551()).field_1724.method_31477() - 20, (class_310.method_1551()).field_1724.method_31478() - 20, (class_310.method_1551()).field_1724.method_31479() - 20))) {
        if ((class_310.method_1551()).field_1687.method_8320(pos).method_26204() == class_2246.field_10490)
          currentYellowPos.add(pos.method_10062()); 
      } 
      for (YellowBlock yellowBlock : yellowPos) {
        if (currentYellowPos.contains(yellowBlock.pos()))
          currentYellowPos.remove(yellowBlock.pos); 
      } 
      for (class_2338 pos : currentYellowPos)
        yellowPos.add(new YellowBlock(System.currentTimeMillis(), pos)); 
      List<YellowBlock> needRemove = new ArrayList<>();
      class_2338 needShot = null;
      for (YellowBlock yellowBlock : yellowPos) {
        if (System.currentTimeMillis() - yellowBlock.time > 3000L)
          needRemove.add(yellowBlock); 
        if (System.currentTimeMillis() - yellowBlock.time < 3000L && System.currentTimeMillis() - yellowBlock.time > 2650L)
          needShot = yellowBlock.pos; 
      } 
      yellowPos.removeAll(needRemove);
      (class_310.method_1551()).field_1724.method_36456((float)RotationUtil.getYaw(needShot.method_46558().method_1031(0.0D, Math.sqrt((class_310.method_1551()).field_1724.method_5707(class_243.method_24954((class_2382)needShot))) * 0.05D, 0.0D)));
      (class_310.method_1551()).field_1724.method_36457((float)RotationUtil.getPitch(needShot.method_46558().method_1031(0.0D, Math.sqrt((class_310.method_1551()).field_1724.method_5707(class_243.method_24954((class_2382)needShot))) * 0.05D, 0.0D)));
      if (needShot != null && (class_310.method_1551()).field_1724.method_6047().method_7909() == class_1802.field_8102 && System.currentTimeMillis() - lastShoot >= 1250L) {
        if ((class_310.method_1551()).field_1687.method_8320(needShot).method_26204() != class_2246.field_10124) {
          (class_310.method_1551()).field_1690.field_1904.method_23481(false);
          lastShoot = System.currentTimeMillis();
        } 
      } else {
        (class_310.method_1551()).field_1690.field_1904.method_23481(true);
      } 
    } 
  }
  
  @ShimmerSubscribe
  public void onRender(RenderEvent.Post event) {
    if (mc.field_1687 == null || mc.field_1724 == null || event.wrc == null || event.wrc.matrixStack() == null)
      return; 
    if (isInSwiftness() && furtherTarget != null)
      RenderUtil.draw3DBox(new class_238(furtherTarget), Color.CYAN, event.wrc.matrixStack(), event.wrc); 
  }
  
  public static boolean isInForce() {
    return LocationUtils.sideBarString.toLowerCase().contains("challenge: force");
  }
  
  public static boolean isInStamina() {
    return LocationUtils.sideBarString.toLowerCase().contains("challenge: stamina");
  }
  
  public static boolean isInMastery() {
    return LocationUtils.sideBarString.toLowerCase().contains("challenge: mastery");
  }
  
  public static boolean isInDiscipline() {
    return LocationUtils.sideBarString.toLowerCase().contains("challenge: discipline");
  }
  
  public static boolean isInSwiftness() {
    return LocationUtils.sideBarString.toLowerCase().contains("challenge: swiftness");
  }
  
  public static boolean isInControl() {
    return LocationUtils.sideBarString.toLowerCase().contains("challenge: control");
  }
  
  public static boolean isInTenacity() {
    return LocationUtils.sideBarString.toLowerCase().contains("challenge: tenacity");
  }
}
