package dev.greencat.shimmer.module.modules.macro;

package .tmp;

import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_7923;

public class AutoTerminal extends Module {
  private static final String START_WITH = "What starts with: ";
  
  private static final String ORDER = "Click in order!";
  
  private static final String LIGHT_UP = "Correct all the panes!";
  
  private static final String COLOR = "Select all the ";
  
  private static final String SAME_COLOR = "Change all to same color!";
  
  private static final String MELODY = "Click the button on time";
  
  private static final class_1792 FRAME_ITEM = class_1802.field_8157;
  
  private static final Map<String, class_1767> colorFromName;
  
  private static final Map<class_1792, class_1767> itemColor;
  
  private static long lastClick = 0L;
  
  private static int randomDelay = 300;
  
  private static Random random = new Random();
  
  public AutoTerminal() {
    super("AutoTerminal", "Auto do F7 Terminal", -1, Module.Category.MACRO);
  }
  
  @ShimmerSubscribe
  public void onTick(TickEvent event) {
    if (System.currentTimeMillis() - lastClick < randomDelay)
      return; 
    class_437 currentScreen = (class_310.method_1551()).field_1755;
    if ((class_310.method_1551()).field_1724 == null || (class_310.method_1551()).field_1687 == null)
      return; 
    if (!(currentScreen instanceof class_476))
      return; 
    class_476 containerScreen = (class_476)currentScreen;
    String TITLE = containerScreen.method_25440().getString();
    if (TITLE.contains("What starts with: ") && 
      TITLE.length() > TITLE.indexOf("'") + 1) {
      char itemNeeded = TITLE.charAt(TITLE.indexOf("'") + 1);
      for (class_1735 slot : ((class_1707)containerScreen.method_17577()).field_7761) {
        if (slot.method_7677().method_7964().getString().charAt(0) != itemNeeded || slot.method_7677().method_7958() || 
          slot.field_7871 == (class_310.method_1551()).field_1724.method_31548())
          continue; 
        if (slot.field_7874 < 9 || slot.field_7874 > 44 || slot.field_7874 % 9 == 0 || slot.field_7874 % 9 == 8)
          continue; 
        mc.field_1761.method_2906(((class_1707)containerScreen.method_17577()).field_7763, slot.field_7874, 0, class_1713.field_7796, (class_1657)mc.field_1724);
        lastClick = System.currentTimeMillis();
        refreshDelay();
      } 
    } 
    if (TITLE.contains("Click in order!")) {
      int currentMinimum = 100;
      int minimumSlotID = -1;
      for (class_1735 slot : ((class_1707)containerScreen.method_17577()).field_7761) {
        if (slot.method_7677().method_7909() == FRAME_ITEM || 
          slot.field_7871 == (class_310.method_1551()).field_1724.method_31548())
          continue; 
        if (slot.method_7677().method_7909() == class_1802.field_8879 && 
          slot.method_7677().method_7947() < currentMinimum) {
          currentMinimum = slot.method_7677().method_7947();
          minimumSlotID = slot.field_7874;
        } 
      } 
      if (minimumSlotID != -1) {
        mc.field_1761.method_2906(((class_1707)containerScreen.method_17577()).field_7763, minimumSlotID, 0, class_1713.field_7796, (class_1657)mc.field_1724);
        lastClick = System.currentTimeMillis();
        refreshDelay();
      } 
    } 
    if (TITLE.contains("Correct all the panes!"))
      for (class_1735 slot : ((class_1707)containerScreen.method_17577()).field_7761) {
        if (slot.method_7677().method_7909() == FRAME_ITEM || 
          slot.field_7871 == (class_310.method_1551()).field_1724.method_31548())
          continue; 
        if (slot.method_7677().method_7909() == class_1802.field_8879) {
          mc.field_1761.method_2906(((class_1707)containerScreen.method_17577()).field_7763, slot.field_7874, 0, class_1713.field_7796, (class_1657)mc.field_1724);
          lastClick = System.currentTimeMillis();
          refreshDelay();
          break;
        } 
      }  
    if (TITLE.contains("Select all the ")) {
      String color = TITLE.split("the ")[1].split(" items")[0];
      class_1767 targetColor = colorFromName.get(color);
      if (targetColor != null)
        for (class_1735 slot : ((class_1707)containerScreen.method_17577()).field_7761) {
          if (slot.method_7677().method_7909() == FRAME_ITEM || 
            slot.field_7871 == (class_310.method_1551()).field_1724.method_31548())
            continue; 
          if (!slot.method_7677().method_7958() && targetColor.equals(itemColor.get(slot.method_7677().method_7909()))) {
            mc.field_1761.method_2906(((class_1707)containerScreen.method_17577()).field_7763, slot.field_7874, 0, class_1713.field_7796, (class_1657)mc.field_1724);
            lastClick = System.currentTimeMillis();
            refreshDelay();
            break;
          } 
        }  
    } 
    if (TITLE.contains("Change all to same color!"))
      for (class_1735 slot : ((class_1707)containerScreen.method_17577()).field_7761) {
        if (slot.method_7677().method_7909() == FRAME_ITEM || 
          slot.field_7871 == (class_310.method_1551()).field_1724.method_31548())
          continue; 
        if (slot.method_7677().method_7909() != class_1802.field_8879) {
          mc.field_1761.method_2906(((class_1707)containerScreen.method_17577()).field_7763, slot.field_7874, 0, class_1713.field_7796, (class_1657)mc.field_1724);
          lastClick = System.currentTimeMillis();
          refreshDelay();
          break;
        } 
      }  
    if (TITLE.contains("Click the button on time")) {
      boolean needClick = false;
      for (class_1735 slot : ((class_1707)containerScreen.method_17577()).field_7761) {
        if (slot.method_7677().method_7909() == FRAME_ITEM || 
          slot.field_7871 == (class_310.method_1551()).field_1724.method_31548())
          continue; 
        if (slot.method_7677().method_7909() == class_1802.field_8581) {
          int i;
          for (i = slot.field_7874; i > 0; i -= 9) {
            if (((class_1707)containerScreen.method_17577()).method_7611(i).method_7677().method_7909() == class_1802.field_8739) {
              needClick = true;
              break;
            } 
          } 
        } 
      } 
      if (needClick)
        for (class_1735 slot : ((class_1707)containerScreen.method_17577()).field_7761) {
          if (slot.method_7677().method_7909() == FRAME_ITEM || 
            slot.field_7871 == (class_310.method_1551()).field_1724.method_31548())
            continue; 
          if (slot.method_7677().method_7909() == class_1802.field_8672) {
            mc.field_1761.method_2906(((class_1707)containerScreen.method_17577()).field_7763, slot.field_7874, 0, class_1713.field_7796, (class_1657)mc.field_1724);
            lastClick = System.currentTimeMillis();
            refreshDelay();
            break;
          } 
        }  
    } 
  }
  
  private static void refreshDelay() {
    randomDelay = random.nextInt(70, 180);
  }
  
  static {
    colorFromName = new HashMap<>();
    for (class_1767 color : class_1767.values())
      colorFromName.put(color.name().toUpperCase(Locale.ENGLISH), color); 
    colorFromName.put("SILVER", class_1767.field_7967);
    colorFromName.put("LIGHT BLUE", class_1767.field_7951);
    itemColor = new HashMap<>();
    for (class_1767 color : class_1767.values()) {
      for (String item : new String[] { "dye", "wool", "stained_glass", "terracotta" })
        itemColor.put((class_1792)class_7923.field_41178.method_63535(class_2960.method_60656(color.name().toLowerCase() + "_" + color.name().toLowerCase())), color); 
    } 
    itemColor.put(class_1802.field_8324, class_1767.field_7952);
    itemColor.put(class_1802.field_8759, class_1767.field_7966);
    itemColor.put(class_1802.field_8116, class_1767.field_7957);
    itemColor.put(class_1802.field_8794, class_1767.field_7963);
  }
}
