package dev.greencat.shimmer.module.modules.macro;

package .tmp;

import dev.greencat.shimmer.Shimmer;
import dev.greencat.shimmer.event.events.RenderEvent;
import dev.greencat.shimmer.event.events.TickEvent;
import dev.greencat.shimmer.eventbus.ShimmerSubscribe;
import dev.greencat.shimmer.module.Module;
import dev.greencat.shimmer.module.modules.player.NickHider;
import dev.greencat.shimmer.setting.Setting;
import dev.greencat.shimmer.setting.settings.ModeSetting;
import dev.greencat.shimmer.util.HaikuLogger;
import dev.greencat.shimmer.util.player.PlayerUtil;
import dev.greencat.shimmer.util.player.WalkerUtils;
import dev.greencat.shimmer.util.render.RenderUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

public class AutoSlayer extends Module {
  public final ModeSetting mode = new ModeSetting("Mob Type", "Choose the mob type you want to kill", "Zombie", new String[] { "Zombie", "Wolf", "Spider" });
  
  private final List<class_1309> blacklist;
  
  private class_1309 prevTarget;
  
  private long lastSearch;
  
  private int count;
  
  public AutoSlayer() {
    super("AutoSlayer", "Do slayer automatically", -1, Module.Category.MACRO);
    this.blacklist = new ArrayList<>();
    this.prevTarget = null;
    this.lastSearch = 0L;
    this.count = 0;
    addSettings(new Setting[] { (Setting)this.mode });
    this.needDisable = true;
  }
  
  @ShimmerSubscribe
  public void onTick(TickEvent event) {
    if (mc.field_1724 == null || mc.field_1687 == null)
      return; 
    if (this.count > 3)
      this.blacklist.add(this.prevTarget); 
    List<class_1309> withInList = new ArrayList<>();
    for (class_1297 entity : mc.field_1687.method_18112()) {
      class_238 hitbox = entity.method_5829();
      if (entity instanceof class_1309 && PlayerUtil.isWithin(
          class_3532.method_15350(mc.field_1724.method_23317(), hitbox.field_1323, hitbox.field_1320), 
          class_3532.method_15350(mc.field_1724.method_23318(), hitbox.field_1322, hitbox.field_1325), 
          class_3532.method_15350(mc.field_1724.method_23321(), hitbox.field_1321, hitbox.field_1324), 2.5D) && 
        PlayerUtil.canSeeEntity(entity) && 
        checkMob((class_1309)entity))
        withInList.add((class_1309)entity); 
    } 
    if (withInList.isEmpty() && !WalkerUtils.isActive()) {
      class_1309 target = getNearestMob();
      if (target == null)
        return; 
      if (this.prevTarget == null || !this.prevTarget.equals(target)) {
        this.prevTarget = target;
        this.count = 0;
      } 
      if (System.currentTimeMillis() - this.lastSearch >= 2000L) {
        this.lastSearch = System.currentTimeMillis();
        HaikuLogger.info(target.toString());
        if (mc.field_1687.method_8320(target.method_24515()).method_26204() instanceof class_2482 && mc.field_1687.method_8320(target.method_24515()).method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
          WalkerUtils.walkTo(target.method_24515());
        } else {
          WalkerUtils.walkTo(target.method_24515().method_10074());
        } 
        this.count++;
      } 
    } 
    if (!withInList.isEmpty() && WalkerUtils.isActive())
      WalkerUtils.cancel(); 
    if (!withInList.isEmpty())
      this.lastSearch = System.currentTimeMillis() - 3000L; 
    Shimmer.getInstance().getModuleManager().getModule("Killaura").setEnabled(!withInList.isEmpty());
  }
  
  public boolean checkMob(class_1309 entity) {
    // Byte code:
    //   0: aload_1
    //   1: getstatic dev/greencat/shimmer/module/modules/macro/AutoSlayer.mc : Lnet/minecraft/class_310;
    //   4: getfield field_1724 : Lnet/minecraft/class_746;
    //   7: invokevirtual equals : (Ljava/lang/Object;)Z
    //   10: ifne -> 26
    //   13: aload_1
    //   14: getstatic dev/greencat/shimmer/module/modules/macro/AutoSlayer.mc : Lnet/minecraft/class_310;
    //   17: getfield field_1719 : Lnet/minecraft/class_1297;
    //   20: invokevirtual equals : (Ljava/lang/Object;)Z
    //   23: ifeq -> 28
    //   26: iconst_0
    //   27: ireturn
    //   28: aload_1
    //   29: instanceof net/minecraft/class_1309
    //   32: ifeq -> 44
    //   35: aload_1
    //   36: astore_2
    //   37: aload_2
    //   38: invokevirtual method_29504 : ()Z
    //   41: ifne -> 51
    //   44: aload_1
    //   45: invokevirtual method_5805 : ()Z
    //   48: ifne -> 53
    //   51: iconst_0
    //   52: ireturn
    //   53: aload_1
    //   54: getstatic dev/greencat/shimmer/module/modules/macro/AutoSlayer.mc : Lnet/minecraft/class_310;
    //   57: getfield field_1724 : Lnet/minecraft/class_746;
    //   60: invokevirtual equals : (Ljava/lang/Object;)Z
    //   63: ifne -> 79
    //   66: aload_1
    //   67: getstatic dev/greencat/shimmer/module/modules/macro/AutoSlayer.mc : Lnet/minecraft/class_310;
    //   70: getfield field_1719 : Lnet/minecraft/class_1297;
    //   73: invokevirtual equals : (Ljava/lang/Object;)Z
    //   76: ifeq -> 81
    //   79: iconst_0
    //   80: ireturn
    //   81: aload_1
    //   82: instanceof net/minecraft/class_1309
    //   85: ifeq -> 97
    //   88: aload_1
    //   89: astore_2
    //   90: aload_2
    //   91: invokevirtual method_29504 : ()Z
    //   94: ifne -> 104
    //   97: aload_1
    //   98: invokevirtual method_5805 : ()Z
    //   101: ifne -> 106
    //   104: iconst_0
    //   105: ireturn
    //   106: aload_1
    //   107: instanceof net/minecraft/class_1309
    //   110: ifeq -> 137
    //   113: aload_1
    //   114: astore_2
    //   115: aload_2
    //   116: invokevirtual method_5767 : ()Z
    //   119: ifeq -> 137
    //   122: aload_0
    //   123: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   126: ldc_w 'Ghost'
    //   129: invokevirtual equals : (Ljava/lang/String;)Z
    //   132: ifne -> 137
    //   135: iconst_0
    //   136: ireturn
    //   137: aload_1
    //   138: instanceof net/minecraft/class_1309
    //   141: ifeq -> 155
    //   144: aload_1
    //   145: astore_2
    //   146: aload_2
    //   147: invokevirtual method_5805 : ()Z
    //   150: ifne -> 155
    //   153: iconst_0
    //   154: ireturn
    //   155: aload_1
    //   156: instanceof net/minecraft/class_1309
    //   159: ifeq -> 173
    //   162: aload_1
    //   163: astore_2
    //   164: aload_2
    //   165: invokevirtual method_5732 : ()Z
    //   168: ifne -> 173
    //   171: iconst_0
    //   172: ireturn
    //   173: aload_1
    //   174: instanceof net/minecraft/class_1657
    //   177: ifeq -> 182
    //   180: iconst_0
    //   181: ireturn
    //   182: aload_0
    //   183: getfield blacklist : Ljava/util/List;
    //   186: aload_1
    //   187: invokeinterface contains : (Ljava/lang/Object;)Z
    //   192: ifeq -> 197
    //   195: iconst_0
    //   196: ireturn
    //   197: aload_0
    //   198: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   201: ldc 'Zombie'
    //   203: invokevirtual equals : (Ljava/lang/String;)Z
    //   206: ifeq -> 233
    //   209: aload_1
    //   210: instanceof net/minecraft/class_1642
    //   213: ifeq -> 231
    //   216: aload_1
    //   217: invokevirtual method_23318 : ()D
    //   220: ldc2_w 70.0
    //   223: dcmpg
    //   224: ifgt -> 231
    //   227: iconst_1
    //   228: goto -> 232
    //   231: iconst_0
    //   232: ireturn
    //   233: aload_0
    //   234: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   237: ldc 'Wolf'
    //   239: invokevirtual equals : (Ljava/lang/String;)Z
    //   242: ifeq -> 250
    //   245: aload_1
    //   246: instanceof net/minecraft/class_1493
    //   249: ireturn
    //   250: aload_0
    //   251: getfield mode : Ldev/greencat/shimmer/setting/settings/ModeSetting;
    //   254: ldc 'Spider'
    //   256: invokevirtual equals : (Ljava/lang/String;)Z
    //   259: ifeq -> 267
    //   262: aload_1
    //   263: instanceof net/minecraft/class_1628
    //   266: ireturn
    //   267: iconst_0
    //   268: ireturn
    // Line number table:
    //   Java source line number -> byte code offset
    //   #98	-> 0
    //   #99	-> 28
    //   #100	-> 53
    //   #101	-> 81
    //   #102	-> 106
    //   #103	-> 135
    //   #105	-> 137
    //   #106	-> 153
    //   #108	-> 155
    //   #109	-> 171
    //   #111	-> 173
    //   #112	-> 180
    //   #114	-> 182
    //   #115	-> 195
    //   #117	-> 197
    //   #118	-> 209
    //   #120	-> 233
    //   #121	-> 245
    //   #123	-> 250
    //   #124	-> 262
    //   #126	-> 267
    // Local variable table:
    //   start	length	slot	name	descriptor
    //   37	7	2	livingEntity	Lnet/minecraft/class_1309;
    //   90	7	2	livingEntity	Lnet/minecraft/class_1309;
    //   115	22	2	livingEntity	Lnet/minecraft/class_1309;
    //   146	9	2	livingEntity	Lnet/minecraft/class_1309;
    //   164	9	2	livingEntity	Lnet/minecraft/class_1309;
    //   0	269	0	this	Ldev/greencat/shimmer/module/modules/macro/AutoSlayer;
    //   0	269	1	entity	Lnet/minecraft/class_1309;
  }
  
  public class_1309 getNearestMob() {
    List<class_1309> targetList = new ArrayList<>();
    for (class_1297 entity : mc.field_1687.method_18112()) {
      if (entity instanceof class_1309) {
        class_1309 livingEntity = (class_1309)entity;
        if (checkMob(livingEntity))
          targetList.add((class_1309)entity); 
      } 
    } 
    List<class_1531> signEntity = new ArrayList<>();
    for (class_1297 entity : mc.field_1687.method_18112()) {
      if (entity instanceof class_1531 && entity.method_16914() && entity.method_5797().getString().contains("Spawned by") && (entity.method_5797().getString().contains(class_310.method_1551().method_1548().method_1676()) || entity.method_5797().getString().contains(NickHider.nickname.getString())))
        signEntity.add((class_1531)entity); 
    } 
    List<class_1309> finalEntity = new ArrayList<>();
    if (!signEntity.isEmpty()) {
      for (class_1297 entity : mc.field_1687.method_18112()) {
        for (class_1531 sign : signEntity) {
          if (entity.method_5739((class_1297)sign) < 2.5D && !(entity instanceof net.minecraft.class_1657) && !(entity instanceof class_1531) && entity instanceof class_1309)
            finalEntity.add((class_1309)entity); 
        } 
      } 
    } else {
      finalEntity = targetList;
    } 
    if (!signEntity.isEmpty() && finalEntity.isEmpty())
      finalEntity = targetList; 
    finalEntity.sort(Comparator.comparingDouble(PlayerUtil::squaredDistanceTo));
    return finalEntity.isEmpty() ? null : finalEntity.getFirst();
  }
  
  @ShimmerSubscribe
  public void onRender(RenderEvent.Post event) {
    if (mc.field_1687 == null || mc.field_1724 == null)
      return; 
    for (class_1297 entity : mc.field_1687.method_18112()) {
      if (entity.method_5845().equals(mc.field_1724.method_5845()))
        continue; 
      if (entity instanceof class_1531 && entity.method_16914() && entity.method_5797().getString().contains("Spawned by") && (entity.method_5797().getString().contains(class_310.method_1551().method_1548().method_1676()) || entity.method_5797().getString().contains(NickHider.nickname.getString()))) {
        RenderUtil.draw3DOutline(RenderUtil.smoothen(entity, entity.method_5829(), event.wrc.tickCounter().method_60637(false)), Color.GREEN, Objects.<class_4587>requireNonNull(event.wrc.matrixStack()), event.wrc);
        class_4184 camera = mc.field_1773.method_19418();
        class_243 start = (new class_243(0.0D, 0.0D, 1.0D)).method_1037(-((float)Math.toRadians(camera.method_19329()))).method_1024(-((float)Math.toRadians(camera.method_19330())));
        class_243 end = RenderUtil.smoothen(entity, event.wrc.tickCounter().method_60637(false)).method_1031(0.0D, entity.method_5751(), 0.0D);
        RenderUtil.draw3DLineFromPlayer(Objects.<class_4587>requireNonNull(event.wrc.matrixStack()), start, end, Color.GREEN, event.wrc);
      } 
    } 
  }
  
  public void onDisable() {
    super.onDisable();
    WalkerUtils.cancel();
  }
}
